/*******************************************************************
 *
 *    DESCRIPTION: DALI Interface SE
 *
 *    AUTHOR:
 *
 *    HISTORY:    
 *
 *******************************************************************/

#include "lib.h"
#include "debug.h"
#include "dali_m2.h"
#include "dali_low_level_master2.h"
#include "tima.h"
#include "tima_hr.h"
#include "globals.h"
#include "ports.h"
#include "sci.h"

#define Input_Capture_OFF()  ClrBit(TACR1,ICIE)
#define Input_Capture_ON()   SetBit(TACR1,ICIE)
#define amReceiving()        (dali_state>=0x10)
#define amSending()          ((dali_state>0) && (dali_state<0x10))
#define	SetDALI1()           SetBit(TACR1,OLVL1)
#define SetDALI0()           ClrBit(TACR1,OLVL1)


void DALI_Send(void);
void Received_A_(unsigned char, unsigned char);
void Reset_Timebase(void);
void Dali_Toggle_Send_Bit(void);

unsigned char dali_state = DALI_IDLE, dali_bit_counter=0, dali_sample_counter=0, dali_shift_reg=0;
unsigned char dali_sample_shift_reg=0;

unsigned char dali_addr_tmp = 0;
unsigned char dali_data_tmp = 0;
unsigned char dali_is_middle = 0;
unsigned int  last_compare1_tima=0;
unsigned int  dali_sampling_base=0;
unsigned char dali_receive_data,dali_receive_status,dali_receive_address;
unsigned char dali_settling;
//unsigned char b_had_reset;

#ifndef INVERTED_RECEIVE
  #pragma INTO_ROM
  const unsigned char compare_table[]={
    0,    /* 000 */
    0,    /* 001 */
    0,    /* 010 */
    1,    /* 011 */
    0,    /* 100 */
    1,    /* 101 */
    1,    /* 110 */
    1     /* 111 */
  };
#else
  #pragma INTO_ROM
  const unsigned char compare_table[]={
    1,    /* 000 */
    1,    /* 001 */
    1,    /* 010 */
    0,    /* 011 */
    1,    /* 100 */
    0,    /* 101 */
    0,    /* 110 */
    0     /* 111 */
  };
#endif

void TimerA_Input_Capt1_For_DALI(void){ /* received something */
  unsigned int timer_sample;

  Write_High_Byte(timer_sample,TAIC1HR); 	/* save input capture */ 
  Write_Low_Byte(timer_sample,TAIC1LR); 	/* save input capture */ 
  Input_Capture_OFF();   /* Disable input capture interrupt */

  timer_sample += DALI_SAMPLING_TIME_RELOAD;
  timer_sample -= DALI_TIMER_LAG;
  dali_sampling_base = timer_sample;
  dali_sample_counter = 0;
  dali_sample_shift_reg = 0;
  dali_state = DALI_RECEIVE_START;
  dali_bit_counter = 0;
  dali_shift_reg = 0;
  TAOC1HR = (timer_sample>>8);
  TAOC1LR = timer_sample;            /* Launch Timer */
}

void TimerA_Output_Comp1_For_DALI(void){
  unsigned char dali_input_pin;

  dali_input_pin = PORTS_Read_DALI_Input();

  if (dali_state == DALI_IDLE){
    asm ld a,TAOC1LR       /* disable tima oc1 */
    asm ld TAOC1HR,a
	return;
  }
  if (amReceiving()){
    dali_sampling_base += DALI_SAMPLING_TIME_RELOAD;
    TAOC1HR = (dali_sampling_base>>8);
    TAOC1LR = dali_sampling_base;         
    dali_sample_counter++;
	if (dali_sample_counter == 4) {
	  return;
	}
	if (dali_sample_counter == 8) {
	  return;
	}
	if (dali_sample_counter >= 9) dali_sample_counter = 1;

    #ifdef DEBUG
      PORTS_SetTestPIN();
    #endif
    dali_sample_shift_reg <<= 1;
    if (dali_input_pin) dali_sample_shift_reg |= 1;
    if (dali_sample_counter == 7) { /* Received a full bi-phase */
      Received_A_(compare_table[(dali_sample_shift_reg >> 3) & 0x07], compare_table[dali_sample_shift_reg & 0x07]);
    }
    #ifdef DEBUG
      PORTS_ClrTestPIN();
    #endif
  } else {
    last_compare1_tima += DALI_BI_SHORT_RELOAD;
    TAOC1HR = (last_compare1_tima>>8);
    TAOC1LR = last_compare1_tima;            /* Launch Timer */
    DALI_Send();
	if (dali_is_middle) {
	  dali_is_middle = 0;
	} else {
	  dali_is_middle = 1;
	}
  }
}

void Reset_Receiver(void){
  dali_state = DALI_IDLE;
  asm ld a,TAOC1LR       /* disable tima oc1 */
  asm ld TAOC1HR,a
  asm ld a,TASR /* clear pending IC interrupts */
  asm ld a,TAIC1LR
  Input_Capture_ON();
//  b_had_reset = 1;
}

void DALI_Init(void){
  Reset_Receiver();
}

unsigned char CheckPhase(unsigned char a, unsigned char b){
  if (a==b) {
    Reset_Receiver();
	return 0;
  } else {
    return 1;
  }
}

void Received_A_(unsigned char a, unsigned char received_bit){
  switch (dali_state) {
    case DALI_IDLE:
	  dali_state = DALI_RECEIVE_START;
      dali_bit_counter = 0;

    case DALI_RECEIVE_START:
      dali_bit_counter++;
	  if (dali_bit_counter > DALI_RECEIVE_NUMBER_START_BITS){ /* is the first addr-bit already */
        PORTS_Switch_Green_LED_OFF();
	    PORTS_Switch_Red_LED_OFF();
	    dali_bit_counter = 0;
		dali_state = DALI_RECEIVE_ADDRESS;
	  } else {
 	    if (!CheckPhase(a,received_bit)) return;
	    if (!received_bit) Reset_Receiver(); /* only 1's are valid */
        return;
	  }

	case DALI_RECEIVE_ADDRESS:
      dali_bit_counter++;
	  if (dali_bit_counter > DALI_RECEIVE_NUMBER_ADDRESS_BITS){ /* is the first databit */
	    dali_bit_counter = 0;
		dali_addr_tmp = dali_shift_reg;
		dali_shift_reg = 0;
		dali_state = DALI_RECEIVE_DATA;
	  } else {
 	    if (!CheckPhase(a,received_bit)) return;
	    dali_shift_reg <<= 1;
		if (received_bit) dali_shift_reg |= 1;
		return;
	  }

	case DALI_RECEIVE_DATA:
      dali_bit_counter++;
	  if (dali_bit_counter > DALI_RECEIVE_NUMBER_DATA_BITS){ /* is the first stopbit */
	    dali_bit_counter = 0;
		dali_data_tmp = dali_shift_reg;
		dali_shift_reg = 0;
		dali_state = DALI_RECEIVE_STOP;
	  } else {
 	    if (!CheckPhase(a,received_bit)) return;
	    dali_shift_reg <<= 1;
		if (received_bit) dali_shift_reg |= 1;
		return;
	  }

	case DALI_RECEIVE_STOP:
	  dali_bit_counter++;
	  if (dali_bit_counter > DALI_RECEIVE_NUMBER_STOP_BITS){
	    dali_state = DALI_RECEIVE_SETTLING;
		dali_bit_counter = 0;
	  } else {
	    if ((a!=1) || (received_bit!=1)) {
		  Reset_Receiver();
		  return;
		}
	  }

	case DALI_RECEIVE_SETTLING:
      dali_bit_counter++;
	  if (dali_bit_counter > ((DALI_TIMEOUT_SEND_SETTLING_SHORT_RELOAD+1)/2)) {
	    PORTS_Switch_Green_LED_ON();
	    switch (dali_receive_status) {
		  case DALI_READY_TO_RECEIVE:
			dali_receive_address = dali_addr_tmp;
			dali_receive_data = dali_data_tmp;
		    dali_receive_status = DALI_NEW_FRAME_RECEIVED;
			break;
		  case DALI_NEW_FRAME_RECEIVED:
		  case DALI_RECEIVE_OVERFLOW:
		    dali_receive_status = DALI_RECEIVE_OVERFLOW;
			break;
	    }
		Reset_Receiver();
		dali_bit_counter = 0;
	  } else {
	    if ((a!=1) || (received_bit!=1)) {
		  Reset_Receiver();
		  return;
		}
	  }
  }
}	    

void Send_DALI_Frame(unsigned char addr, unsigned char data){
  while (amSending());
  Input_Capture_OFF();
  dali_bit_counter=0;
  dali_is_middle = 0;
  dali_settling = 0;//DALI_TIMEOUT_SEND_SETTLING_SHORT_RELOAD-1;
  dali_addr_tmp = addr;
  dali_data_tmp = data;
  dali_state = DALI_SEND_START;
  Reset_Timebase();
}

void Send_DALI_Frame_Wait_Settling(unsigned char addr, unsigned char data){
  while (amSending());
  Input_Capture_OFF();
  dali_bit_counter=0;
  dali_is_middle = 0;
  dali_settling = DALI_TIMEOUT_SEND_SETTLING_LONG_RELOAD;
  dali_addr_tmp = addr;
  dali_data_tmp = data;
  dali_state = DALI_SEND_START;
  Reset_Timebase();
}

unsigned char Receive_DALI_Frame_Normal(void){
  dali_receive_status = DALI_READY_TO_RECEIVE;
  while (amSending()); 
  TIMA_ShortTimer(DALI_TIMEOUT_RECEIVE_ANSWER_RELOAD);
  while ((dali_state == DALI_IDLE) && TIMA_ShortTimerCountDown);
  if (dali_state == DALI_IDLE) { /* still idle -> got a timeout */
    return DALI_RECEIVE_TIMEOUT;
  } else {
//    TIMA_ShortTimer(DALI_TIMEOUT_RECEIVE_ANSWER_RELOAD*6);
//	while ((dali_receive_status == DALI_READY_TO_RECEIVE) && TIMA_ShortTimerCountDown);
    while (dali_state != DALI_IDLE); /* no timer, the state has to go back to idle SOMETIME! */
	if (dali_receive_status == DALI_READY_TO_RECEIVE){
	  return DALI_RECEIVE_TIMEOUT;
	}else{
      return dali_receive_status;
	}
  }
}

unsigned char Receive_DALI_Frame_COMPARE_(void){
  dali_receive_status = DALI_READY_TO_RECEIVE;
  while (amSending()); 
  TIMA_ShortTimer(DALI_TIMEOUT_RECEIVE_ANSWER_RELOAD);
  while ((dali_state == DALI_IDLE) && TIMA_ShortTimerCountDown);
  if (dali_state == DALI_IDLE) { /* still idle -> got a timeout */
    return 0;  /* Nothing happened */
  } else {
    while (dali_state != DALI_IDLE); /* no timer, the state has to go back to idle SOMETIME! */
	return 1;
  }
}

unsigned char Receive_DALI_Frame_COMPARE(void){
  unsigned char i,da;

  da = 0;

  for (i=0; i<3; i++) {
    TIMA_ShortTimer(DALI_TIMEOUT_RECEIVE_ANSWER_RELOAD);
    while (TIMA_ShortTimerCountDown);
    TIMA_ShortTimer(DALI_TIMEOUT_RECEIVE_ANSWER_RELOAD);
    while (TIMA_ShortTimerCountDown);
    TIMA_ShortTimer(DALI_TIMEOUT_RECEIVE_ANSWER_RELOAD);
    while (TIMA_ShortTimerCountDown);

    Send_DALI_Frame(169,0);
    da += Receive_DALI_Frame_COMPARE_();
  }

  if (da > 1) {
    dali_receive_status = DALI_NEW_FRAME_RECEIVED;
    dali_receive_data = 255;
    return DALI_NEW_FRAME_RECEIVED;
  } else {
    return DALI_RECEIVE_TIMEOUT;
  }
}

unsigned char Receive_DALI_Frame(void){
//  if (b_is_compare){
//    return Receive_DALI_Frame_COMPARE();
//  } else {
    return Receive_DALI_Frame_Normal();
//  }
}

void DALI_Send(void){
  switch (dali_state){
    case DALI_SEND_START:
	  if (!dali_is_middle) {
	    dali_bit_counter++;
  	    if (dali_bit_counter > DALI_SEND_NUMBER_START_BITS){
		  PORTS_Switch_Green_LED_OFF();
		  PORTS_Switch_Red_LED_OFF();
	      dali_state = DALI_SEND_ADDRESS;
		  dali_bit_counter = 0;
	    } else {
		  SetDALI0();
		  return;
		}
	  } else { /* is middle */
	    SetDALI1();
		return;
	  }

	case DALI_SEND_ADDRESS:
	  if (!dali_is_middle) {
	    dali_bit_counter++;
		if (dali_bit_counter > DALI_SEND_NUMBER_ADDRESS_BITS){
		  dali_state = DALI_SEND_DATA;
		  dali_bit_counter = 0;
		} else {
		  if (ValBit(dali_addr_tmp,7)) {
		    SetDALI0();
		  } else {
		    SetDALI1();
		  }
		  dali_addr_tmp <<= 1;
		  return;
		}
	  } else { /* is middle */
	    Dali_Toggle_Send_Bit();
		return;
	  }

	case DALI_SEND_DATA:
	  if (!dali_is_middle) {
	    dali_bit_counter++;
		if (dali_bit_counter > DALI_SEND_NUMBER_DATA_BITS){
		  dali_state = DALI_SEND_STOP;
		  dali_bit_counter = 0;
		} else {
		  if (ValBit(dali_data_tmp,7)) {
		    SetDALI0();
		  } else {
		    SetDALI1();
		  }
		  dali_data_tmp <<= 1;
		  return;
		}
	  } else { /* is middle */
	    Dali_Toggle_Send_Bit();
		return;
	  }

	case DALI_SEND_STOP:
	  if (!dali_is_middle){
  	    dali_bit_counter++;
		if (dali_bit_counter > DALI_SEND_NUMBER_STOP_BITS){
		  dali_state = DALI_SEND_SETTLING;
		  dali_bit_counter = 0;
		} else {
 	      SetDALI1();
		}
 	    return;
	  }

    case DALI_SEND_SETTLING:
	  if (!dali_is_middle){
	    if (dali_settling == 0) {
		  dali_state = DALI_IDLE;
		  dali_bit_counter = 0;
		  Reset_Receiver();
		  PORTS_Switch_Green_LED_ON();
		} else {
		  SetDALI1();
  	      dali_settling--;
		}
	  }
  }
}

void Dali_Toggle_Send_Bit (void){
  if (ValBit(TACR1,OLVL1)){
  	ClrBit(TACR1,OLVL1);
  } else {
	SetBit(TACR1,OLVL1);
  }
}

void Reset_Timebase(void){
  Write_High_Byte(last_compare1_tima,TAACHR); 	/* save counter */ 
  Write_Low_Byte(last_compare1_tima,TAACLR); 	/* save counter */ 

  last_compare1_tima += DALI_BI_SHORT_RELOAD; 	/* load new compare value */ 
	    
  TAOC1HR = (last_compare1_tima>>8);     
  TAOC1LR = last_compare1_tima; 
	
  asm {
    LD A,TASR           /* Clear the flags in case it is already set. */
    LD A,TAOC1LR        /* OC1F flag: Read Status Register and Access OC1R low byte */ 
  } 
}
		  
	    