/**************** (c) 1999 STMicroelectronics **********************

PROJECT  :    
COMPILER : ST7 HICROSS C (HIWARE)

MODULE  :  lib.h
VERSION : 

CREATION DATE : 01.99

AUTHOR : PPG 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 *****************************************************************************/

/* PUBLIC DECLARATIONS *******************************************************/

#ifndef LIB_H
#define LIB_H
            
/*--------------------------STANDARD TYPE DEFINITION-------------------------*/
#define uByte unsigned char               /* unsigned 8 bit type definition  */
#define uWord unsigned int                /* unsigned 16 bit type definition */
                                       
typedef union {                           /* unsigned 16 bit type for 8 & 16 */
          unsigned int w_form;            /* bit accesses: 16> var.w_form    */
          struct {                        /* 8> var.b_form.high/low          */
                  unsigned char high, low;
          } b_form;
  } TwoBytes;

/*--------------------------------BIT ACCESSES-------------------------------*/
#define SetBit(VAR,Place)         ( VAR |= (1<<Place) )
#define ClrBit(VAR,Place)         ( VAR &= ((1<<Place)^255) )
#define AffBit(VAR,Place,Value)   ((Value) ? \
                                   (VAR |= (1<<Place)) : \
                                   (VAR &= ((1<<Place)^255)))
#define MskBit(Dest,Msk,Src)      ( Dest = (Msk & Src) | ((~Msk) & Dest) )

#define ValBit(VAR,Place)         (VAR & (1<<Place))

/*--------------------------------BYTE ACCESSES-------------------------------*/
#define Write_Low_Byte(dest,src)        {asm LD A,src; asm LD dest:1,A;}
#define Write_High_Byte(dest,src)        {asm LD A,src; asm LD dest,A;}

#endif

/*** (c) 1999 STMicroelectronics ****************** END OF FILE ***/
