/**************** (c) 1999  STMicroelectronics **********************
     
PROJECT  :
COMPILER : ST7 HICROSS C (HIWARE)

MODULE  :  main.c
VERSION :  

CREATION DATE : 01.99 

AUTHOR : PPG 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Main Routine
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

/* Include files */

#include "hidef.h"      /* Hiware library */
#include "lib.h"        /* Predifined libraries working at bit level */
#include "debug.h"      /* Debugging options */
#include "tima.h"
#include "sci.h"
#include "ports.h" 
#include "ports_hr.h" 
#include "globals.h"
#include "dali_m2.h" 
#include "dali_m2.h"  
#include "tima.h"
#include "tima_hr.h"


unsigned char i_error;
#ifdef DEBUG
  #define DEBUGSTRING "D"
#else
  #define DEBUGSTRING "R"
#endif
#ifdef INVERTED_RECEIVE
  #define INVREC_STRING "I"
#else
  #define INVREC_STRING "N"
#endif
#ifdef OPEN_DRAIN_OUTPUT
  #define OD_STRING "O"
#else
  #define OD_STRING "P"
#endif
#if (CPU_CLK==4e6)
  #define CPUVER "4"
#else
  #define CPUVER "8"
#endif
#ifdef TEST_SENDING_MASTER
  #define TSMSTR "T"
#else
  #define TSMSTR " "
#endif

#pragma CONST_SEG CS_VERSION
const volatile unsigned char version[3][0x10]={
  "ST7 DALI Master ",
  "1.1.136." CPUVER DEBUGSTRING INVREC_STRING OD_STRING TSMSTR "   ",
  "(c)2000 by ST   "
};
#pragma CONST_SEG DEFAULT


//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-



void main(void)
{ 
  version[0][0];
  PORTS_Init();
  PORTS_Switch_Red_LED_ON();
  PORTS_Switch_Green_LED_ON();
  TIMA_Init();
  SCI_Init();
  EnableInterrupts;  
  DALI_Init();
  SCI_SendAnswerToPC(SCIERR_ACK_RESET,0);
	SetBit(TACR1,OLVL1);
  
  while(1) {

    i_error = SCI_GetCommand();
	if (i_error == SCI_NO_ERROR) {
      i_error = SCI_DispatchCommand();
      if (i_error == SCI_NO_ERROR) {
        if (b_flush_sci_buffer) {      
          SCI_FlushBufferToDALI();
 	      if (b_is_dali_answer_rqrd) {
		    switch (Receive_DALI_Frame()){
			
			  case DALI_RECEIVE_TIMEOUT:
  		        i_error = SCIERR_DALI_TIMED_OUT;
  	            dali_receive_data = 0;
			  break;
	        
	          case DALI_NEW_FRAME_RECEIVED:
		        //i_error = SCI_NO_ERROR;  /* berflssig */
		      break;
		    
		      case DALI_RECEIVE_OVERFLOW:
		        i_error = SCIERR_RECEIVE_OVERFLOW;
		        dali_receive_data = 0;
		      break;
            
//              case DALI_READY_TO_RECEIVE:
//                i_error = 71;
//			  break;

              default: 
			   i_error = 255;
   			  break;
		    } // switch
		    dali_receive_status = DALI_READY_TO_RECEIVE;
	      } else {
		    dali_receive_data = 0;
	      }// if answer rqrd
	    } else {       // if flushbuffer
		  dali_receive_data = 0;
	    }              // if flushbuffer
	  } // if dispatch ok
	}
	PORTS_Switch_Red_LED_OFF();
	PORTS_Switch_Green_LED_OFF();
	if (i_error == SCI_NO_ERROR)
	  PORTS_Switch_Green_LED_ON();
	else
	  PORTS_Switch_Red_LED_ON();
	SCI_SendAnswerToPC(i_error, dali_receive_data);
  } // while(1) loop                            

} // main loop

/*** (c) 1999  STMcroelectronics ****************** END OF FILE ***/
