/**************** (c) 1999  STMicroelectronics **********************

PROJECT  : 
COMPILER : ST7 HICROSS C (HIWARE)

MODULE  :  map72331.c
VERSION :  

CREATION DATE : 01.99 

AUTHOR : PPG 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : ST72331 Hardware Register Mapping.

              This file contains the description of the hardware registers of
              the ST72331 Microcontroller.
              
 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#include "ports_hr.h"
#include "misc_hr.h"
#include "spi_hr.h"
#include "tima_hr.h"
#include "timb_hr.h"
#include "wdg_hr.h"
#include "adc_hr.h"
#include "sci_hr.h"
#include "eep_hr.h"


/* ***************************************
   Peripherals Registers Definition
   *************************************** */                                                                     
                                                                  
/* I/O ports registers */ 
#pragma DATA_SEG SHORT PORT_A
  volatile unsigned char PADR;                  /* port A data register             */          
  unsigned char PADDR;                          /* port A data direction register   */
  unsigned char PAOR;                           /* port A option register           */  
                                                             
#pragma DATA_SEG SHORT PORT_C
  volatile unsigned char PCDR;                  /* port C data register             */          
  unsigned char PCDDR;                          /* port C data direction register   */
  unsigned char PCOR;                           /* port C option register           */
  
#pragma DATA_SEG SHORT PORT_B
  volatile unsigned char PBDR;                  /* port B data register             */          
  unsigned char PBDDR;                          /* port B data direction register   */
  unsigned char PBOR;                           /* port B option register           */

#pragma DATA_SEG SHORT PORT_E
  volatile unsigned char PEDR;                  /* port E data register             */          
  unsigned char PEDDR;                          /* port E data direction register   */
  unsigned char PEOR;                           /* port E option register           */

#pragma DATA_SEG SHORT PORT_D
  volatile unsigned char PDDR;                  /* port D data register             */          
  unsigned char PDDDR;                          /* port D data direction register   */
  unsigned char PDOR;                           /* port D option register           */
  
#pragma DATA_SEG SHORT PORT_F
  volatile unsigned char PFDR;                  /* port F data register             */          
  unsigned char PFDDR;                          /* port F data direction register   */
  unsigned char PFOR;                           /* port F option register           */
  
                                                                                                                                                           
/* Miscellaneous Register */                                                 
#pragma DATA_SEG SHORT MISC                                                  
  unsigned char MISCR;                          /* Miscellaneous register            */
   
/* Serial Peripheral Interface */                                            
#pragma DATA_SEG SHORT SPI
  volatile unsigned char SPIDR;                 /* SPI Data Register                 */
  unsigned char SPICR;                          /* SPI Control Register              */
  volatile unsigned char SPISR;                 /* SPI Status Register               */

/* Watchdog Register */                                                                        
#pragma DATA_SEG SHORT WDG                                                                     
  volatile unsigned char WDGCR;                /* Watchdog control register        */         
  volatile unsigned char WDGSR;                /* Watchdog status register         */
                            
/* Timer A */
#pragma DATA_SEG SHORT TIMERA
  unsigned char TACR2;                          /* timer A control register 2                 */
  unsigned char TACR1;                          /* timer A control register 1                 */
  volatile unsigned char TASR;                  /* timer A status register                    */
  volatile unsigned char TAIC1HR;               /* timer A input capture 1 high register      */
  volatile unsigned char TAIC1LR;               /* timer A input capture 1 low register       */
  unsigned char TAOC1HR;                        /* timer A output compare 1 high register     */
  unsigned char TAOC1LR;                        /* timer A output compare 1 low register      */
  volatile unsigned char TACHR;                 /* timer A counter high register              */
  volatile unsigned char TACLR;                 /* timer A counter low register               */
  volatile unsigned char TAACHR;                /* timer A alternate counter high register    */
  volatile unsigned char TAACLR;                /* timer A alternate counter low register     */
  volatile unsigned char TAIC2HR;               /* timer A input capture 2 high register      */
  volatile unsigned char TAIC2LR;               /* timer A input capture 2 low register       */
  unsigned char TAOC2HR;                        /* timer A output compare 2 high register     */
  unsigned char TAOC2LR;                        /* timer A output compare 2 low register      */

/* Timer B */
#pragma DATA_SEG SHORT TIMERB
  unsigned char TBCR2;                          /* timer B control register 2                 */
  unsigned char TBCR1;                          /* timer B control register 1                 */
  volatile unsigned char TBSR;                  /* timer B status register                    */
  volatile unsigned char TBIC1HR;               /* timer B input capture 1 high register      */
  volatile unsigned char TBIC1LR;               /* timer B input capture 1 low register       */
  unsigned char TBOC1HR;                        /* timer B output compare 1 high register     */
  unsigned char TBOC1LR;                        /* timer B output compare 1 low register      */
  volatile unsigned char TBCHR;                 /* timer B counter high register              */
  volatile unsigned char TBCLR;                 /* timer B counter low register               */
  volatile unsigned char TBACHR;                /* timer B alternate counter high register    */
  volatile unsigned char TBACLR;                /* timer B alternate counter low register     */
  volatile unsigned char TBIC2HR;               /* timer B input capture 2 high register      */
  volatile unsigned char TBIC2LR;               /* timer B input capture 2 low register       */
  unsigned char TBOC2HR;                        /* timer B output compare 2 high register     */
  unsigned char TBOC2LR;                        /* timer B output compare 2 low register      */

/* SCI Registers*/
#pragma DATA_SEG SHORT SCI
  volatile unsigned char SCISR;                 /* SCI Status Register                         */
  volatile unsigned char SCIDR;                 /* SCI Data Register                           */ 
  unsigned char SCIBRR;                         /* SCI Baud rate Register                      */
  volatile unsigned char SCICR1;                /* SCI Control Register 1                      */
  volatile unsigned char SCICR2;                /* SCI Control Register 2                      */
  unsigned char SCIERPR;                        /* SCI Extended receive prescaler register     */
  unsigned char RESERV;                         /* Reserved                                    */
  unsigned char SCIETPR;                        /* SCI Extended transmit prescaler register    */
 
/* Analog To Digital Converter */                                            
#pragma DATA_SEG SHORT ADC
  volatile unsigned char ADCDR;                 /* ADC Data Register                 */
  volatile unsigned char ADCCSR;                /* ADC Control Status Register       */

/* EEPROM */                                            
#pragma DATA_SEG SHORT EEPROMCR
  volatile unsigned char EEPCR;                 /* EEPROM Control Register           */


/*** (c) 1999 STMicroelectronics ****************** END OF FILE ***/
