/**************** (c) 1999 STMicroelectronics **********************

PROJECT  : 
COMPILER : ST7 HICROSS C (HIWARE)

MODULE  :  ports.c
VERSION :  

CREATION DATE : 01.99

AUTHOR : PPG 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#include "lib.h"
#include "debug.h"
#include "ports_hr.h"
#include "ports.h"
#include "misc_hr.h" 

#define PORTS_RED_LED      7
#define PORTS_GREEN_LED    6
#define PORTS_DALI_RECEIVE 6
#define PORTS_TEST_PIN     3

/*-----------------------------------------------------------------------------
ROUTINE NAME : Init_Ports
INPUT/OUTPUT : None

DESCRIPTION  : Configure the ports

COMMENTS     :
-----------------------------------------------------------------------------*/
void PORTS_Init(void)
{
    PADDR    = 0x00;    /* Port A Bit 7 & 6 as Output (Debug) */
	SetBit(PADDR,PORTS_TEST_PIN);
	SetBit(PADDR,PORTS_RED_LED);
	SetBit(PADDR,PORTS_GREEN_LED);
    PAOR     = 0x00;    
	SetBit(PAOR,PORTS_TEST_PIN);

    PBDDR    = 0x00;                   
    PBOR     = 0x00;                   

    PCDDR    = 0x00;                   
    PCOR     = 0x00;                   

    PDDDR    = 0x00;
    PDOR     = 0x00;       

    PEDDR    = 0x00;
    PEOR     = 0x00;       

    PFDDR    = 0x00;
    PFOR     = 0x00;       
    
    MISCR = 0x00;               /* select interrupt sesitivity for port pins */
}

void PORTS_SetTestPIN(void){
  SetBit(PADR,PORTS_TEST_PIN);
}

void PORTS_ClrTestPIN(void){
  ClrBit(PADR,PORTS_TEST_PIN);
}

unsigned char PORTS_Read_DALI_Input(void){
  return ValBit(PFDR,PORTS_DALI_RECEIVE);
}

void PORTS_Switch_Red_LED_ON(void){
  ClrBit(PADR,PORTS_RED_LED);
}

void PORTS_Switch_Red_LED_OFF(void){
  SetBit(PADR,PORTS_RED_LED);
}

void PORTS_Switch_Green_LED_ON(void){
  ClrBit(PADR,PORTS_GREEN_LED);
}

void PORTS_Switch_Green_LED_OFF(void){
  SetBit(PADR,PORTS_GREEN_LED);
}

#pragma TRAP_PROC SAVE_REGS
/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_0_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : 

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void PORTS_0_Interrupt(void)
{
}

#pragma TRAP_PROC SAVE_REGS
/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_1_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : 

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void PORTS_1_Interrupt(void)
{
}

#pragma TRAP_PROC SAVE_REGS
/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_2_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : 

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void PORTS_2_Interrupt(void)
{
}

#pragma TRAP_PROC SAVE_REGS
/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_3_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : 

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void PORTS_3_Interrupt(void)
{
}


/*** (c) 1999  STMicroelectronics ****************** END OF FILE ***/


