/**************** (c) 1999 STMicroelectronics **********************

PROJECT  : 
COMPILER : ST7 HICROSS C (HIWARE)

MODULE  :  sci.c
VERSION :  

CREATION DATE : 01.99 

AUTHOR : PPG 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#include "lib.h"
#include "debug.h"
#include "sci_hr.h"
#include "sci.h"
#include "tima.h"
#include "dali_m2.h"
#include "globals.h"

#define SCI_COMMAND_BUFFER_SIZE 3

#define SCI_COMMAND_FRAME_WINDOW 5
#define false 0
#define true  1

static uByte iRcvd[3];
volatile static uByte iRcvCnt;
static uByte iTrmCnt;
//static uByte i_sci_error_code;
static uByte i_sci_send_buffer[2];
static uByte i_sci_command_buffer[2][SCI_COMMAND_BUFFER_SIZE];
static uByte i_sci_command_counter;


/*-----------------------------------------------------------------------------
ROUTINE NAME : SCI_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the SCI

COMMENTS     :
-----------------------------------------------------------------------------*/
void SCI_Init (void) {
  i_sci_command_counter = 0;
  SCIERPR=SCI_DIVISION_FACTOR;  // Extended Prescaler Division
  SCIETPR=SCI_DIVISION_FACTOR;
  ClrBit(SCICR1,M);
  SetBit(SCICR2,RE);   //Receiver Enable
  SetBit(SCICR2,TE);   //Transmitter enable
  iRcvCnt = 0;
}

#ifndef TEST_SENDING_MASTER
uByte SCI_GetCommand(void) {
  iRcvCnt = 0;
  SetBit(SCICR2,RIE);  //Receiver Interrupt Enable
  while (iRcvCnt == 0);
  TIMA_LaunchTimer(SCI_COMMAND_FRAME_WINDOW);
  while ( (iRcvCnt < 3) && (TIMA_TimerCountDown > 0) );
  ClrBit(SCICR2,RIE);  //Receiver Interrupt Disable
  iRcvd[2]--;
  TIMA_LaunchTimer2(35);    /* Make sure, the answer via rs232 is at least */
  if (iRcvd[0] == 169){	                                   /* DALI_COMPARE */
    b_is_compare = 1;
  } else {
    b_is_compare = 0;
  }
  if (TIMA_TimerCountDown == 0) {  /* 35 ms delayed, to avoid the rolf-bug */
    return SCIERR_RECEIVE_TIMEOUT;
  } else {
    return SCI_NO_ERROR;
  }
}
#else
uByte SCI_GetCommand(void) {
  unsigned int counter;
  unsigned char counter2;
  iRcvCnt = 0;

  counter2 = 4;
  while (counter2){
    counter2--;
    counter = 1;
    while (counter) counter++;
  }
  iRcvCnt = 3;
  iRcvd[0] = 255;
  iRcvd[1] = 145;
  iRcvd[2] = 2;
  return SCI_NO_ERROR;
}
#endif
uByte SCI_BufferCommand(void){
  if (i_sci_command_counter >= SCI_COMMAND_BUFFER_SIZE) {
    i_sci_command_counter = 0;
    return false;
  }
  i_sci_command_buffer[0][i_sci_command_counter] = iRcvd[0];
  i_sci_command_buffer[1][i_sci_command_counter] = iRcvd[1];
  i_sci_command_counter++;
  return true;
}

void SCI_SendAnswerToPC(unsigned char i_errcode, unsigned char i_dali_answer) {
  iRcvCnt = 0;
  iTrmCnt = 0;

  while (TIMA_TimerCountDown2); /* wait for the 35ms timer to finish */

  i_sci_send_buffer[0] = i_errcode+1;//i_sci_error_code;
  i_sci_send_buffer[1] = i_dali_answer;
  SetBit(SCICR2,TIE);  //Transmitter Interrupt Enable
}

uByte SCI_DispatchCommand(void) {

  b_flush_sci_buffer = 1;
  b_is_dali_answer_rqrd = 0;

  switch (iRcvd[2]) {
    case 1:
      b_flush_sci_buffer = 0;
    break;

  	case 2:
  	  b_is_dali_answer_rqrd = 1;
  	break;

  	default:
	break;
  }
 
  if( !SCI_BufferCommand() ){
    return SCIERR_COMMAND_BUFFER_OVERRUN;
  }
  return SCI_NO_ERROR;
}

void SCI_FlushBufferToDALI(void){
  char i;

  if (i_sci_command_counter != 0)
    for (i = 0; i < i_sci_command_counter; i++) {
      if (i==i_sci_command_counter-1) {
        Send_DALI_Frame(i_sci_command_buffer[0][i], i_sci_command_buffer[1][i]);
	  } else {
	    Send_DALI_Frame_Wait_Settling(i_sci_command_buffer[0][i], i_sci_command_buffer[1][i]);
	  }
    }

  i_sci_command_counter = 0;
}

#pragma TRAP_PROC SAVE_REGS
/*-----------------------------------------------------------------------------
ROUTINE NAME : SCI_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : SCI Interrupt Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void SCI_Interrupt (void) {
  if (ValBit(SCISR,RDRF) != 0) {
	if (iRcvCnt < 3) {
      iRcvd[iRcvCnt++] = SCIDR;
	}
  }
  if (ValBit(SCISR,TDRE) != 0) {
    if (iTrmCnt != 2) {
      SCIDR = i_sci_send_buffer[iTrmCnt++];
	} else {
      ClrBit(SCICR2,TIE);  //Transmitter Interrupt Disable
	}
  }
}


/*** (c) 1999  STMicroelectronics ****************** END OF FILE ***/

