/**************** (c) 1999 STMicroelectronics **********************

PROJECT  : 
COMPILER : ST7 HICROSS C (HIWARE)

MODULE  :  sci_hr.h
VERSION :  

CREATION DATE : 01.99

AUTHOR : PPG 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#ifndef SCI_HR_H
#define SCI_HR_H

/*---REGISTERS---*/ 

#pragma DATA_SEG SHORT SCI
extern  volatile unsigned char SCISR;  /* SCI Status Register                         */
extern  volatile unsigned char SCIDR;  /* SCI Data Register                           */ 
extern  unsigned char SCIBRR;          /* SCI Baud rate Register                      */
extern  volatile unsigned char SCICR1; /* SCI Control Register 1                      */
extern  volatile unsigned char SCICR2; /* SCI Control Register 2                      */
extern  unsigned char SCIERPR;         /* SCI Extended receive prescaler register     */
extern  unsigned char RESERV;          /* Reserved                                    */
extern  unsigned char SCIETPR;         /* SCI Extended transmit prescaler register    */
   
#pragma DATA_SEG DEFAULT


/*---CONSTANTS---*/

/* SCI status register bit definition  */

#define TDRE        0x07        /* Tansmit data register empty */
#define TC          0x06        /* Transmission complete       */
#define RDRF        0x05        /* Received data ready flag    */
#define IDLE        0x04        /* Idle line detect            */
#define _0R         0x03        /* Overrun error               */
#define NF          0x02        /* Noise flag                  */
#define FE          0x01        /* Framing error               */

/* SCI control register 1 bit definition */
#define R8          0x07        /* Receive data bit8           */
#define T8          0x06        /* Transmit data bit8          */
#define M           0x04        /* Word lenght                 */
#define WAKE        0x03        /* Wake-up method              */

/* SCI control register 2 bit definition */
#define TIE         0x07        /* Transmitter interrupt enable */
#define TCIE        0x06        /* Transmission complete interrupt enable */
#define RIE         0x05        /* Receiver interupt enable    */ 
#define ILIE        0x04        /* Idle line interrupt enable  */
#define TE          0x03        /* Transmitter enable          */
#define RE          0x02        /* Receiver enable             */            
#define RWU         0x01        /* Receiver wake_up            */
#define SBK         0x00        /* Send break                  */
 

#endif


/*** (c) 1999  STMicroelectronics ****************** END OF FILE ***/

