/**************** (c) 1999 STMicroelectronics **********************

PROJECT  : 
COMPILER : ST7 HICROSS C (HIWARE)

MODULE  :  tima.c
VERSION :  

CREATION DATE : 01.99 

AUTHOR : PPG 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Functions Timer A
              
 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#include "lib.h"
#include "debug.h"
#include "tima_hr.h"
#include "tima.h"
#include "dali_m2.h"
#include "globals.h"

unsigned int  timercounter;
unsigned int  TIMA_TimerCountDown;
unsigned int  TIMA_TimerCountDown2;
unsigned char TIMA_ShortTimerCountDown;


/*-----------------------------------------------------------------------------
ROUTINE NAME : TIMA_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the Timer A

COMMENTS     :
-----------------------------------------------------------------------------*/
void TIMA_Init(void)
{

/*      CONTROL REGISTER 1:     7 6 5 4 3 2 1 0
                                X - - - - - - -         ICIE: Input Capture Interrupt Enable
                                - X - - - - - -         OCIE: Output Compare Interrupt Enable
                                - - X - - - - -         TOIE: Timer Overflow Interrupt Enable
                                - - - X - - - -         FOLV2: Force Output Compare 2
                                - - - - X - - -         FOLV1: Force Output Compare 1
                                - - - - - X - -         OLVL2: Output Level 2
                                - - - - - - X -         IEDG1: Input Edge 1
                                - - - - - - - X         OLVL1: Output Level 1
                                1 1 0 0 0 0 0 1                    */
   TACR1=0xc1;                
   #ifdef INVERTED_RECEIVE
     SetBit(TACR1,IEDG1);
   #endif

/*      CONTROL REGISTER 2:     7 6 5 4 3 2 1 0
                                X - - - - - - -         OC1E: Output Compare 1 Enable
                                - X - - - - - -         OC2E: Output Compare 2 Enable
                                - - X - - - - -         OPM: One Pulse Mode
                                - - - X - - - -         PWM: Pulse Width Modulation Mode
                                - - - - X - - -         CC1: Timer Clock: 0 fcpu/4 0 fcpu/2 1 fcpu/8 1 ext
                                - - - - - X - -         CC0:              0        1        0        1
                                - - - - - - X -         IEDG2: Input Edge 2
                                - - - - - - - X         EXEDG: External Clock Edge
                                1 0 0 0 0 1 0 0                    */
  TACR2=0x84;
  
  TAOC1HR=0x00;
  TAOC1LR=0x00;
   
/* IF YOU DON'T  WANT TO USE OC2 OR IC2 INTERRUPT, YOU HAVE TO DISABBLE IT: */
  asm
  {
	LD TAIC2HR,A;		/* Write the Input Capture 2 register to disable the IC2 */

    LD A,TASR           /* Clear the flags in case it is already set. To Clear  */
    LD A,TACLR          /* TOF flag: Read Status Register and Access CNT low byte */ 
    LD A,TAOC1LR        /* OC1F flag: Read Status Register and Access OC1R low byte */ 
    LD A,TAOC2LR        /* OC2F flag: Read Status Register and Access OC2R low byte */
    LD A,TAIC1LR        /* IC1F flag: Read Status Register and Access IC1R low byte */ 
    LD A,TAIC2LR        /* IC2F flag: Read Status Register and Access IC2R low byte */
  }
  timercounter = TACHR<<8;
  timercounter += TACLR;

}

void TIMA_RunTimer(void){
  Write_High_Byte(timercounter, TACHR);
  Write_Low_Byte(timercounter, TACLR);
  timercounter += TIME_BASE_RELOAD;
  TAOC2HR = (timercounter>>8);
  TAOC2LR = timercounter;            /* Launch Timer by Writing a complete Word to the Regs */
}

void TIMA_LaunchTimer(unsigned int timer_value){
  TIMA_TimerCountDown=timer_value;
  if (!TIMA_TimerCountDown2) {
    TIMA_RunTimer();
  }
}

void TIMA_LaunchTimer2(unsigned int timer_value){
  TIMA_TimerCountDown2 = timer_value;
  if (!TIMA_TimerCountDown) {
    TIMA_RunTimer();
  }
}

void TIMA_ShortTimer(unsigned int reload){
  TIMA_ShortTimerCountDown = 0;
  Write_High_Byte(timercounter, TACHR);
  Write_Low_Byte(timercounter, TACLR);
  timercounter += reload;
  TAOC2HR = timercounter>>8;
  TAOC2LR = timercounter;
  TIMA_ShortTimerCountDown = 1;
}

void TIMA_Switch_Receiver(unsigned char sw) {
  if (sw==ON) {
    SetBit(TACR1, ICIE);
  } else {
    ClrBit(TACR1, ICIE);
  }
}

#pragma TRAP_PROC SAVE_REGS
/*-----------------------------------------------------------------------------
ROUTINE NAME : TimerA_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : timer Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void TIMA_Interrupt(void)
{
   if (ValBit(TASR,OCF1)) /* OC1? */
   {
     TimerA_Output_Comp1_For_DALI();
   }
   else 
     if (ValBit(TASR,OCF2)) /* OC2? */
     {
	   if (TIMA_ShortTimerCountDown) {
	     TIMA_ShortTimerCountDown = 0;
	   } else {
	     if (TIMA_TimerCountDown!=0)  TIMA_TimerCountDown--;
		 if (TIMA_TimerCountDown2!=0) TIMA_TimerCountDown2--;
	   }
	   if ((TIMA_TimerCountDown | TIMA_TimerCountDown2)) {
	     timercounter += TIME_BASE_RELOAD;
	     TAOC2HR = (timercounter>>8);
	     TAOC2LR = timercounter;
	   } else {
  	     asm LD TAOC2HR,A /* Disable OC2-Timer */
	   }
     }
     else
       if (ValBit(TASR,ICF1)) /* IC1? */
       {
         TimerA_Input_Capt1_For_DALI();
       }
       else
         if (ValBit(TASR,ICF2)) /* IC2? */
         {
           asm LD A, TAIC2LR; /* clear IC2 flag */
		   asm LD TAIC2HR, A; /* disable IC2 */
         }
         else                   /* TOF! */
         {
           asm LD A, TACLR; /* clear TOF flag */
         }
}

/*** (c) 1999  STMicroelectronics ****************** END OF FILE ***/
 


