/**************** (c) 1999 STMicroelectronics **********************

PROJECT  : 
COMPILER : ST7 HICROSS C (HIWARE)

MODULE  :  tima.h
VERSION :  

CREATION DATE : 01.99

AUTHOR :  PPG 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   File with all the functions used in the other routines. 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#ifndef TIMA_H
#define TIMA_H

/*---FUNCTIONS---*/

void TIMA_Init(void);

extern unsigned int  TIMA_TimerCountDown;
extern unsigned int	 TIMA_TimerCountDown2;
extern unsigned char TIMA_ShortTimerCountDown;
void TIMA_LaunchTimer(unsigned int);
void TIMA_LaunchTimer2(unsigned int);
void TIMA_ShortTimer(unsigned int);
void TIMA_Switch_Receiver(unsigned char);

/*---CONSTANTS---*/
#define	CPU_CLK			8e6					/* Internal Frequency */
#define TIMER_CLK   	(CPU_CLK/2)			/* Timer: Frequency if Timer prescaler is 2*/
#define TIMER_TICK  	(1e6/TIMER_CLK)		/* Timer: smallest timebase in us */
#define TIME_BASE		    1000 			/* Timer: timebase in us */ 
#define TIME_BASE_RELOAD	(unsigned int)(TIME_BASE/TIMER_TICK)	/* Timer: reload value for timebase */	

#define SCI_DIVISION_FACTOR (unsigned int) (CPU_CLK*13/4e6)

#endif

/*** (c) 1999  STMicroelectronics ****************** END OF FILE ***/

