/**************** (c) 1999 STMicroelectronics **********************

PROJECT  : 
COMPILER : ST7 HICROSS C (HIWARE)

MODULE  :  timb.c
VERSION :  

CREATION DATE : 01.99

AUTHOR : PPG 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Functions Timer B
              
 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#include "lib.h"
#include "debug.h"
#include "timb_hr.h"
#include "timb.h"

/*-----------------------------------------------------------------------------
ROUTINE NAME : TIMB_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the Timer B

COMMENTS     :
-----------------------------------------------------------------------------*/
void TIMB_Init(void)
{
/*      CONTROL REGISTER 1:     7 6 5 4 3 2 1 0
                                X - - - - - - -         ICE: Input Capture Interrupt Enable
                                - X - - - - - -         OCIE: Output Compare Interrupt Enable
                                - - X - - - - -         TOIE: Timer Overflow Interrupt Enable
                                - - - X - - - -         FOLV2: Force Output Compare 2
                                - - - - X - - -         FOLV1: Force Output Compare 1
                                - - - - - X - -         OLVL2: Output Level 2                       "Summerausgang "
                                - - - - - - X -         IEDG1: Input Edge 1
                                - - - - - - - X         OLVL1: Output Level 1
                                0 0 0 0 0 0 0 0                    */
  // TBCR1=;                

/*      CONTROL REGISTER 2:     7 6 5 4 3 2 1 0
                                X - - - - - - -         OC1E: Output Compare 1 Enable
                                - X - - - - - -         OC2E: Output Compare 2 Enable              "Summerausgang "
                                - - X - - - - -         OPM: One Pulse Mode
                                - - - X - - - -         PWM: Pulse Width Modulation Mode
                                - - - - X - - -         CC1: Timer Clock: 0 fcpu/4 0 fcpu/2 1 fcpu/8 1 ext
                                - - - - - X - -         CC0:              0        1        0        1
                                - - - - - - X -         IEDG2: Input Edge 2
                                - - - - - - - X         EXEDG: External Clock Edge
                                0 0 0 0 0 0 0 0                    */
  // TBCR2=;
  

}



#pragma TRAP_PROC SAVE_REGS                /* Zusaetzliche Register werden gerettet */
/*-----------------------------------------------------------------------------
ROUTINE NAME : TMIB_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : timer Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void TIMB_Interrupt(void)
{  
   
}  /* End of void TimerB_Interrupt(void) */


/*** (c) 1999  STMicroelectronics ****************** END OF FILE ***/
 


