/**************** (c) 1999 ST Microelectronics **********************

PROJECT  : 
COMPILER : ST7 HICROSS C (HIWARE)

MODULE  :  timb_hr.h
VERSION :  

CREATION DATE : 01.99

AUTHOR :  PPG 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#ifndef TIMB_HR_H
#define TIMB_HR_H


/*---REGISTERS---*/ 

#pragma DATA_SEG SHORT TIMERB
extern  unsigned char TBCR2;              /* timer B control register 2                 */
extern  unsigned char TBCR1;              /* timer B control register 1                 */
extern  volatile unsigned char TBSR;      /* timer B status register                    */
extern  volatile unsigned char TBIC1HR;   /* timer B input capture 1 high register      */
extern  volatile unsigned char TBIC1LR;   /* timer B input capture 1 low register       */
extern  unsigned char TBOC1HR;            /* timer B output compare 1 high register     */
extern  unsigned char TBOC1LR;            /* timer B output compare 1 low register      */
extern  volatile unsigned char TBCHR;     /* timer B counter high register              */
extern  volatile unsigned char TBCLR;     /* timer B counter low register               */
extern  volatile unsigned char TBACHR;    /* timer B alternate counter high register    */
extern  volatile unsigned char TBACLR;    /* timer B alternate counter low register     */
extern  volatile unsigned char TBIC2HR;   /* timer B input capture 2 high register      */
extern  volatile unsigned char TBIC2LR;   /* timer B input capture 2 low register       */
extern  unsigned char TBOC2HR;            /* timer B output compare 2 high register     */
extern  unsigned char TBOC2LR;            /* timer B output compare 2 low register      */

#pragma DATA_SEG DEFAULT

/*---CONSTANTS---*/

#ifndef TIMA_HR_H

/* Timers A&B Control Register 1 bit definition  */

#define ICIE        0x07        /* Input capture interrupt enable       */                             
#define OCIE        0x06        /* Output compare interrupt enable      */                      
#define TOIE        0x05        /* Timer overflow interrupt enable      */
#define OLVL2       0x02        /* Output level 2                       */
#define IEDG1       0x01        /* Input edge 1                         */
#define OLVL1       0x00        /* Ouput level 1                        */

/* Timers A&B Control Register 2 bit definition  */

#define OC1E        0x07        /* Output compare 1 pin                 */
#define OC2E        0x06        /* Output compare 1 pin                 */
#define OPM         0x05        /* One pulse mode                       */
#define PWM         0x04        /* PWM Mode                             */
#define IEDG2       0x01        /* Input edge 2                         */
                                                                        
/* Timer A&B Status register bit definition  */

#define ICF1        0x07        /* Input capture 1 flag                 */
#define OCF1        0x06        /* Output compare 1 flag                */
#define TOF         0x05        /* Timer overflow flag                  */
#define ICF2        0x04        /* Input capture 2 flag                 */
#define OCF2        0x03        /* Output compare 2 flag                */
                                                                         
#endif

#endif

/*** (c) 1999  STMicroelectronics ****************** END OF FILE ***/

