Attribute VB_Name = "Configs"
Option Explicit

Private Config As SettingClass

Public Sub Save(Filename As String)
  Dim i As Byte
  
  Set Config = New SettingClass
  Config.Init Filename
  i = 0
  Do While MainForm.DALIBals.Exists(i)
    Config.PutStr "Ballast" & i, "Short", "" & MainForm.DALIBals.Item(i).ShortAddress
    i = i + 1
  Loop
  Set Config = Nothing
  MainForm.SetStatus "Configuration saved."
End Sub

Public Sub Load(Filename As String)
  Dim i, short As Byte
  
  Set Config = New SettingClass
  Config.Init Filename
  i = 0
  MainForm.ClearGrid
  MainForm.DALIBals.Clear
  MainForm.BalSelection.Clear
  Do While Not ("NotFound" = Config.GetStr("Ballast" & i, "Short", "NotFound"))
    short = Config.GetInt("Ballast" & i, "Short", 0)
    If DALIBus.TestShort(DALI_AD_SHORT + short) Then
      MainForm.DALIBals.Add "" & i
      MainForm.DALIBals.Item("" & i).ShortAddress = short
    Else
      MsgBox "The Ballast with the Short Address " & short & " did not respond." & Chr(10) & _
             "Loading has been canceled."
      BallastGrid.Update
      Set Config = Nothing
      Exit Sub
    End If
    i = i + 1
  Loop
  BallastGrid.Update
  Set Config = Nothing
  MainForm.SetStatus "Configuration loaded."
End Sub
