VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "comctl32.ocx"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Object = "{3710B56A-3E38-4178-A228-C4C7B5CC7EB5}#1.0#0"; "DALIControl.ocx"
Begin VB.Form MainForm 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "STMicroelectronics -- DALI Control 2.1"
   ClientHeight    =   615
   ClientLeft      =   45
   ClientTop       =   480
   ClientWidth     =   6315
   Icon            =   "MenuForm.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   OLEDropMode     =   1  'Manual
   ScaleHeight     =   615
   ScaleWidth      =   6315
   Begin ComctlLib.Toolbar MainToolbar 
      Height          =   390
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   7350
      _ExtentX        =   12965
      _ExtentY        =   688
      ButtonWidth     =   609
      ButtonHeight    =   582
      ImageList       =   "ImageList1"
      _Version        =   327682
      BeginProperty Buttons {0713E452-850A-101B-AFC0-4210102A8DA7} 
         NumButtons      =   5
         BeginProperty Button1 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   "New"
            Object.ToolTipText     =   "Resets Ballast Configuration"
            Object.Tag             =   ""
            ImageIndex      =   1
         EndProperty
         BeginProperty Button2 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   "Open"
            Object.ToolTipText     =   "Open Configuration"
            Object.Tag             =   ""
            ImageIndex      =   2
         EndProperty
         BeginProperty Button3 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   "Save"
            Object.ToolTipText     =   "Save Configuration"
            Object.Tag             =   ""
            ImageIndex      =   3
         EndProperty
         BeginProperty Button4 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   ""
            Object.Tag             =   ""
            Style           =   3
            MixedState      =   -1  'True
         EndProperty
         BeginProperty Button5 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   "Search"
            Object.ToolTipText     =   "Search for connected Ballasts"
            Object.Tag             =   ""
            ImageIndex      =   4
         EndProperty
      EndProperty
      OLEDropMode     =   1
   End
   Begin DALIInterface.DALIControl DALIControl 
      Left            =   1920
      Top             =   1440
      _ExtentX        =   1058
      _ExtentY        =   1032
   End
   Begin VB.Timer StatusTimer 
      Interval        =   20
      Left            =   3000
      Top             =   1080
   End
   Begin MSComDlg.CommonDialog CommonDialog 
      Left            =   5040
      Top             =   1200
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      DefaultExt      =   ".cfg"
      Filter          =   "Configuration Files (*.CFG)|*.cfg|All Files (*.*)|*.*"
   End
   Begin ComctlLib.StatusBar StatusBar 
      Align           =   2  'Align Bottom
      Height          =   255
      Left            =   0
      TabIndex        =   1
      Top             =   360
      Width           =   6315
      _ExtentX        =   11139
      _ExtentY        =   450
      Style           =   1
      SimpleText      =   "Ready"
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   1
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
      OLEDropMode     =   1
   End
   Begin ComctlLib.ImageList ImageList1 
      Left            =   3840
      Top             =   1080
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   327682
      BeginProperty Images {0713E8C2-850A-101B-AFC0-4210102A8DA7} 
         NumListImages   =   4
         BeginProperty ListImage1 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "MenuForm.frx":030A
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "MenuForm.frx":041C
            Key             =   ""
         EndProperty
         BeginProperty ListImage3 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "MenuForm.frx":052E
            Key             =   ""
         EndProperty
         BeginProperty ListImage4 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "MenuForm.frx":0640
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.Menu Menu_File 
      Caption         =   "&File"
      Begin VB.Menu NEW_CONFIG 
         Caption         =   "&New..."
      End
      Begin VB.Menu OPEN_CONFIG 
         Caption         =   "&Open..."
      End
      Begin VB.Menu SAVE_CONFIG 
         Caption         =   "&Save..."
      End
      Begin VB.Menu hgfdhgdrs 
         Caption         =   "-"
      End
      Begin VB.Menu Menu_Exit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu Menu_View 
      Caption         =   "&View"
      Begin VB.Menu Menu_Show_BallastGrid 
         Caption         =   "&Ballast Grid"
         Checked         =   -1  'True
      End
      Begin VB.Menu Menu_Show_LL_Slider 
         Caption         =   "&LightLevel Slider"
         Checked         =   -1  'True
      End
      Begin VB.Menu Menu_Show_Selection 
         Caption         =   "&Selection"
      End
      Begin VB.Menu Menu_Scene 
         Caption         =   "S&cene"
      End
      Begin VB.Menu MENU_COMEar 
         Caption         =   "&DALILogger"
      End
   End
   Begin VB.Menu Menu_Options 
      Caption         =   "&Options"
      Begin VB.Menu Menu_Config 
         Caption         =   "&Configuration..."
      End
      Begin VB.Menu bhjvrbhj 
         Caption         =   "-"
      End
      Begin VB.Menu MENU_SETARC 
         Caption         =   "Set &ARC Function..."
         Enabled         =   0   'False
      End
      Begin VB.Menu jnbnjbrtsnjtbr 
         Caption         =   "-"
      End
      Begin VB.Menu Menu_ChangeSceneName 
         Caption         =   "Change &Scene Names..."
      End
      Begin VB.Menu Menu_ChangeGroupName 
         Caption         =   "Change &Group Names..."
      End
      Begin VB.Menu liuhliuzlui 
         Caption         =   "-"
      End
      Begin VB.Menu MENU_RUN_OLD_INTERFACE 
         Caption         =   "Send &DALI Commands..."
      End
      Begin VB.Menu MENU_RUN_TEST_CONF_PROCS 
         Caption         =   "Run Conformity &Test Procedures..."
         Enabled         =   0   'False
      End
   End
   Begin VB.Menu MENU_EXTRA 
      Caption         =   "E&xtras"
      Begin VB.Menu SEARCH 
         Caption         =   "&Search for Ballasts..."
      End
      Begin VB.Menu MENU_RUN_DEMO 
         Caption         =   "Run automated &Demo"
      End
   End
   Begin VB.Menu Menu_Help 
      Caption         =   "&Help"
      Begin VB.Menu Menu_About 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Public flag  As Boolean
Public BalSelection As TDALIBalBunch
Public DALIBals As TDALIBallastContainer
Public Settings As SettingClass

Private oldstr$, newstr$, strcounter%


Private Sub Form_OLEDragDrop(data As DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single)
  Configs.Load data.Files(1)
End Sub

Private Sub MainToolbar_OLEDragDrop(data As ComctlLib.DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single)
  Configs.Load data.Files(1)
End Sub

'Private Sub MainToolbar_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
'   SetStatus "Load/Save Configs, Search for Ballasts"
'End Sub

Private Sub Menu_ChangeGroupName_Click()
  GroupNames.Visible = True
End Sub

Private Sub MENU_COMEar_Click()
  MENU_COMEar.Checked = Not MENU_COMEar.Checked
  COMEar.Visible = MENU_COMEar.Checked
End Sub

Private Sub MENU_EXTRA_Click()
  SetStatus "Special Commands"
End Sub

Private Sub Menu_File_Click()
  SetStatus "Exit Program?"
End Sub

Private Sub Menu_Help_Click()
  SetStatus "About DALI Master"
End Sub

Private Sub Menu_Options_Click()
  SetStatus "DALI Settings"
End Sub

Private Sub MENU_RUN_DEMO_Click()
  frmDemo.Visible = True
End Sub

Private Sub MENU_RUN_OLD_INTERFACE_Click()
  frmManual.Visible = True
End Sub

Private Sub MENU_RUN_TEST_CONF_PROCS_Click()
  frmConformity.Visible = True
End Sub

Private Sub Menu_View_Click()
  SetStatus "Adjust visible Windows"
End Sub

Private Sub NEW_CONFIG_Click()
  MainForm.ClearGrid
  MainForm.DALIBals.Clear
  MainForm.BalSelection.Clear
  BallastGrid.Update
  SetStatus "Configuration has been reset"
End Sub

Private Sub OPEN_CONFIG_Click()
  CommonDialog.ShowOpen
  If Not (CommonDialog.Filename = "") Then
    Configs.Load CommonDialog.Filename
  End If
End Sub

Private Sub SAVE_CONFIG_Click()
  CommonDialog.ShowSave
  If Not (CommonDialog.Filename = "") Then
    Configs.Save CommonDialog.Filename
  End If
End Sub

Private Sub SEARCH_Click()
  SetStatus "Running Search..."
  SearchForm.Visible = True
End Sub

Private Sub StatusBar_OLEDragDrop(data As ComctlLib.DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single)
  Configs.Load data.Files(1)
End Sub

Private Sub StatusTimer_Timer()
  If oldstr = newstr Then
    StatusTimer.Enabled = False
    Exit Sub
  End If
  If strcounter > Len(newstr) Then
    StatusBar.SimpleText = newstr
    StatusTimer.Enabled = False
    Exit Sub
  End If
  If strcounter > Len(oldstr) Then
    oldstr = Left(newstr, strcounter)
  Else
    oldstr = Left(newstr, strcounter) & Right(oldstr, Len(oldstr) - strcounter)
  End If
  strcounter = strcounter + 1
  StatusBar.SimpleText = oldstr
End Sub

Public Sub SetStatus(NewString$)
  StatusTimer.Enabled = False
  strcounter = 1
  newstr = NewString
  oldstr = StatusBar.SimpleText
  StatusTimer.Enabled = True
End Sub


Public Sub ClearGrid()
  DALIBals.Clear
End Sub


Private Sub DALIControl_DALIError(Errcode As TDALIError)
  flag = True
  Select Case Errcode
    Case DALI_A_ERR_CommandBufferOverrun:
      MsgBox "Command Buffer Overrun. This might be an addressing conflict, as two or more Ballasts could be sharing the same short address."
      SetStatus "Error: Command Buffer Overrun."
    Case DALI_A_ERR_GeneralError
      'MsgBox "General Error"
      SetStatus "General Error."
    Case DALI_A_ERR_InvalidFrames
      MsgBox "There seems to be something wrong with the COM Connection. Please check the Settings."
      SetStatus "Error: Invalid Frames."
    Case DALI_A_ERR_SCIReceiveOverflow
      MsgBox "There seems to be something wrong with the COM Connection. Please check the Settings."
      SetStatus "Error: SCI Receive Overflow."
    Case DALI_A_ERR_SCIReceiveTimeout
      MsgBox "There seems to be something wrong with the COM Connection. Please check the Settings."
      SetStatus "Error:SCI Receive Timeout."
    Case DALI_A_ERR_SCITimedOut
       
      Select Case MsgBox("DALIBoard did not respond!" & Chr(10) & _
                         "Please connect the board and press Retry.", vbCritical + vbAbortRetryIgnore + vbApplicationModal)
        Case vbAbort
          End
        Case vbIgnore
        Case vbRetry
      End Select
    Case DALI_A_ERR_MultiUsed
      'MsgBox "DALI_A_ERR_MultiUsed"
      SetStatus "Error: Multiused"
    Case DALI_A_ERR_NoAnswer
      MsgBox "Unknown DALI Address! You should run a Full Search!"
      SetStatus "Run a Full Search!"
    Case Else
      
      MsgBox "Unknown Error #" & Errcode
      SetStatus "Error #" & Errcode
  End Select
End Sub

Private Sub Form_Load()
  frmSplash.Visible = True
  DoEvents
  Set Settings = New SettingClass
  If (Settings.GetInt("VisibleWindows", "BallastGrid", 1) = 0) Then
    Menu_Show_BallastGrid.Checked = False
  Else
    BallastGrid.Visible = True
  End If
  If (Settings.GetInt("VisibleWindows", "LightLevel", 1) = 0) Then
    Menu_Show_LL_Slider.Checked = False
  Else
    LightLevel.Visible = True
  End If
  If (Settings.GetInt("VisibleWindows", "Selection", 0) = 1) Then
    Menu_Show_Selection_Click
  End If
  If (Settings.GetInt("VisibleWindows", "Scene", 0) = 1) Then
    Menu_Scene_Click
  End If
  If (Settings.GetInt("VisibleWindows", "COMEar", 0) = 1) Then
    MENU_COMEar_Click
  End If
  Settings.WindowPostionRestore MainForm
  Set BalSelection = New TDALIBalBunch
  Set DALIBals = New TDALIBallastContainer
  
  'DALIControl.COMPort = 3
  'DALIControl.PortOpen = True
  
  DALIBus.WaitForBoard
  ClearGrid
  DoEvents
End Sub

Private Sub Form_Resize()
  Dim i As Form
  If Me.WindowState = 1 Then
    For Each i In Forms
      If Not i Is Me Then
        i.Visible = False
      End If
    Next i
  End If
  If Me.WindowState = 0 Then
    For Each i In Forms
      If Not i Is Me Then
        i.Visible = True
      End If
    Next i
  End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Dim i As Form
  If Menu_Show_BallastGrid.Checked Then
    Settings.ClearKey "VisibleWindows", "BallastGrid"
  Else
    Settings.PutInt "VisibleWindows", "BallastGrid", 0
  End If
  
  If Menu_Show_LL_Slider.Checked Then
    Settings.ClearKey "VisibleWindows", "LightLevel"
  Else
    Settings.PutInt "VisibleWindows", "LightLevel", 0
  End If
  
  If Menu_Show_Selection.Checked Then
    Settings.PutInt "VisibleWindows", "Selection", 1
  Else
    Settings.ClearKey "VisibleWindows", "Selection"
  End If
  
  If Menu_Scene.Checked Then
    Settings.PutInt "VisibleWindows", "Scene", 1
  Else
    Settings.ClearKey "VisibleWindows", "Scene"
  End If
  
  If MENU_COMEar.Checked Then
    Settings.PutInt "VisibleWindows", "COMEar", 1
  Else
    Settings.ClearKey "VisibleWindows", "COMEar"
  End If
  Settings.WindowPostionSave MainForm
  If DALIControl.PortOpen = True Then
    DALIControl.PortOpen = False
  End If
  For Each i In Forms
    Unload i
  Next i
  End
End Sub

Private Sub MainToolbar_ButtonClick(ByVal Button As ComctlLib.Button)
  Select Case Button.key
    Case "New"
      MainForm.ClearGrid
      MainForm.DALIBals.Clear
      MainForm.BalSelection.Clear
      BallastGrid.Update
      SetStatus "Configuration has been reset"
    Case "Open"
      CommonDialog.ShowOpen
      If Not (CommonDialog.Filename = "") Then
        Configs.Load CommonDialog.Filename
      End If
    Case "Save"
      CommonDialog.ShowSave
      If Not (CommonDialog.Filename = "") Then
        Configs.Save CommonDialog.Filename
      End If
    Case "Search"
      SetStatus "Running Search..."
      SearchForm.Visible = True
  End Select
End Sub

Private Sub Menu_About_Click()
  frmAbout.Visible = True
End Sub

Private Sub Menu_ChangeSceneName_Click()
  SceneNames.Visible = True
End Sub

Private Sub Menu_Config_Click()
  ConfigForm.Visible = True
End Sub

Private Sub Menu_Exit_Click()
  End
End Sub

Private Sub Menu_Scene_Click()
  Menu_Scene.Checked = Not Menu_Scene.Checked
  SceneForm.Visible = Menu_Scene.Checked
End Sub

Private Sub MENU_SETARC_Click()
  ARCForm.Visible = True
End Sub

Private Sub Menu_Show_BallastGrid_Click()
  Menu_Show_BallastGrid.Checked = Not Menu_Show_BallastGrid.Checked
  BallastGrid.Visible = Menu_Show_BallastGrid.Checked
End Sub

Private Sub Menu_Show_LL_Slider_Click()
  Menu_Show_LL_Slider.Checked = Not Menu_Show_LL_Slider.Checked
  LightLevel.Visible = Menu_Show_LL_Slider.Checked
End Sub

Private Sub Menu_Show_Selection_Click()
  Menu_Show_Selection.Checked = Not Menu_Show_Selection.Checked
  SelectionForm.Visible = Menu_Show_Selection.Checked
End Sub
