Attribute VB_Name = "DALIBus"
Option Explicit
Public Const TestDALI_SCITimedOutErrOK = 15130 + DALI_A_ERR_SCITimedOut
Public Const TestDALI_SCITimedOutErrCancel = 32000
Public bLastRet As Boolean
Private iActSearchAddr As Long

'Public Function GetDescr(cmd As TDALICommand) As String
'  GetDescr = MainForm.DALIControl.GetDescr(cmd)
'End Function

Public Function SupressErrors()
  MainForm.DALIControl.SupressErrors
End Function

Public Function Send(cmd As TDALICommand, Optional addr As TDALIAddress = 0, Optional data As Byte = 0) As Variant
  If COMEar.Enabled Then
    COMEar.Log "[" & cmd & "] " & MainForm.DALIControl.GetDescr(cmd)
    If MainForm.DALIControl.isAddrRqrd(cmd) Then
      COMEar.Log " (" & addr
      If MainForm.DALIControl.isDataRqrd(cmd) Then
        COMEar.Log "," & data
      End If
      COMEar.Log ")"
    Else
      If MainForm.DALIControl.isDataRqrd(cmd) Then
        COMEar.Log " (" & data & ")"
      End If
    End If
  End If
  Send = MainForm.DALIControl.SendCommand(cmd, addr, data) 'what does it mean?????
  If COMEar.Enabled Then
    Select Case MainForm.DALIControl.WhatTypeOfAnswer(cmd)
      Case DALICA_OK
        COMEar.LogNL ""
      Case DALICA_YESNO
        If Send Then
          COMEar.LogNL " -- YES"
        Else
          COMEar.LogNL " -- NO"
        End If
      Case DALICA_8BIT
        COMEar.LogNL " -- " & Send
    End Select
  End If
End Function

'Public Function SendManual(cb1 As Byte, cb2 As Byte, flags As TDALICommandFlags, Optional ExpectedAnswer As TDALICommandAnswer = DALICA_OK)
'  SendManual = MainForm.DALIControl.SendCommandManual(cb1, cb2, flags, ExpectedAnswer)
'End Function


Public Sub CheckComm()
  Send DALI_QueryBallast, DALI_AD_SHORT + 0
End Sub

'Public Sub WaitForBoard()
'  SupressErrors
'  Do While (Send(DALI_QueryBallast, DALI_AD_SHORT + 0) = DALI_A_ERR_SCITimedOut)
'    SupressErrors
'    If MsgBox("DALI Board did not answer!" & Chr(10) & _
'              "Probably it is not connected.", vbRetryCancel) = vbCancel Then
'      End
'    End If
'  Loop
'End Sub

Public Sub WaitForBoard()
  SupressErrors
  If Send(DALI_QueryBallast, DALI_AD_SHORT + 0) = DALI_A_ERR_SCITimedOut Then
    MainForm.SetStatus "Warning: No Connection to DALI Board found!"
  End If
End Sub

Public Sub Terminate()
  Send DALI_Terminate
End Sub

Private Property Let SearchAddr(SEARCH As Long)
  Send DALI_SetSearchAddrH, data:=SEARCH \ 65536
  Send DALI_SetSearchAddrM, data:=(SEARCH \ 256) Mod 256
  Send DALI_SetSearchAddrL, data:=(SEARCH Mod 256)
  iActSearchAddr = SEARCH
End Property

Private Property Get SearchAddr() As Long
  SearchAddr = iActSearchAddr
End Property

Public Function Find(ShortToProgram As Byte) As Boolean
  Dim Division As Long
  Dim SEARCH As Long
  
  'SearchAddr = &HFFFFFF
  SEARCH = &HFFFFFF
  Send DALI_SetSearchAddrH, data:=SEARCH \ 65536
  If (MainForm.TestDALI_SCITimedOutError = TestDALI_SCITimedOutErrOK) Then Exit Function
  Send DALI_SetSearchAddrM, data:=(SEARCH \ 256) Mod 256
  If (MainForm.TestDALI_SCITimedOutError = TestDALI_SCITimedOutErrOK) Then Exit Function
  Send DALI_SetSearchAddrL, data:=(SEARCH Mod 256)
  If (MainForm.TestDALI_SCITimedOutError = TestDALI_SCITimedOutErrOK) Then Exit Function
  iActSearchAddr = SEARCH
  If Not Send(DALI_Compare) Then
    Find = False
    Exit Function
  End If
  If (MainForm.TestDALI_SCITimedOutError = TestDALI_SCITimedOutErrOK) Then Exit Function
  
  'SearchAddr = &H800000
  SEARCH = &H800000
  Division = &H400000
  'SearchForm.StepCount = 0  'bar di avanzamento in searchform
  Send DALI_SetSearchAddrH, data:=SEARCH \ 65536
  If (MainForm.TestDALI_SCITimedOutError = TestDALI_SCITimedOutErrOK) Then Exit Function
  Send DALI_SetSearchAddrM, data:=(SEARCH \ 256) Mod 256
  If (MainForm.TestDALI_SCITimedOutError = TestDALI_SCITimedOutErrOK) Then Exit Function
  Send DALI_SetSearchAddrL, data:=(SEARCH Mod 256)
  If (MainForm.TestDALI_SCITimedOutError = TestDALI_SCITimedOutErrOK) Then Exit Function
  iActSearchAddr = SEARCH
  Do
    If Send(DALI_Compare) Then
      SearchAddr = SearchAddr - Division
    Else
      SearchAddr = SearchAddr + Division
    End If
    If (MainForm.TestDALI_SCITimedOutError = TestDALI_SCITimedOutErrOK) Then Exit Function
    'Debug.Print SearchAddr; Division; SearchForm.StepCount
    'SearchForm.StepCount = SearchForm.StepCount + 1 'bar di avanzamento in searchform
    Division = Division \ 2
  Loop Until Division = 0
  If Send(DALI_Compare) Then
    SearchAddr = SearchAddr - 1
    If Send(DALI_Compare) Then
      ProgramShort ShortToProgram
    Else
      SearchAddr = SearchAddr + 1
      ProgramShort ShortToProgram
    End If
  Else
    SearchAddr = SearchAddr + 1
    ProgramShort ShortToProgram
  End If
  'Debug.Print SearchAddr
  Find = True
End Function

Private Sub ProgramShort(short As Byte)
  Send DALI_ProgramShortAddress, DALI_AD_SHORT + short
  Send DALI_Withdraw
End Sub

Public Function TestShort(addr As Byte) As Boolean
  TestShort = Send(DALI_QueryBallast, DALI_AD_SHORT + addr)
End Function

Public Sub ProgramNewShort(OldShort, NewShort As Byte)
  Send DALI_SetDTR, data:=NewShort * 2
  Send DALI_StoreDTRAsShortAddress, DALI_AD_SHORT + OldShort
End Sub

Public Sub Initialize()
  Send DALI_Initialize
  Send DALI_Randomize
End Sub

Public Function IsBoardOnline() As Boolean
  On Error GoTo ErrorHandler
  Send DALI_QueryBallast, DALI_AD_SHORT + 0
  IsBoardOnline = True
  Exit Function
ErrorHandler:
  IsBoardOnline = False
End Function

