VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "comctl32.ocx"
Begin VB.Form SearchForm 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Find"
   ClientHeight    =   2790
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   4560
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2790
   ScaleWidth      =   4560
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin ComctlLib.ProgressBar SearchBar 
      Align           =   2  'Align Bottom
      Height          =   255
      Left            =   0
      TabIndex        =   3
      Top             =   2535
      Width           =   4560
      _ExtentX        =   8043
      _ExtentY        =   450
      _Version        =   327682
      Appearance      =   1
   End
   Begin VB.CommandButton CancelSearch 
      Cancel          =   -1  'True
      Caption         =   "Close"
      Height          =   375
      Left            =   2640
      TabIndex        =   5
      Top             =   720
      Width           =   1695
   End
   Begin VB.CommandButton StartSearch 
      Caption         =   "Start Search"
      Height          =   375
      Left            =   2640
      TabIndex        =   4
      Top             =   240
      Width           =   1695
   End
   Begin VB.Frame Frame1 
      Caption         =   "Type of Search"
      Height          =   1575
      Left            =   120
      TabIndex        =   0
      ToolTipText     =   "Quick Search tests all 64 Short Addresses for responding Ballasts"
      Top             =   120
      Width           =   2295
      Begin VB.OptionButton PhysSel 
         Caption         =   "Physical Selection"
         Height          =   255
         Left            =   240
         TabIndex        =   9
         Top             =   1080
         Width           =   1815
      End
      Begin VB.OptionButton FullSearch 
         Caption         =   "Full Search"
         Height          =   195
         Left            =   240
         TabIndex        =   2
         ToolTipText     =   "Full Search does a complete INITIALIZE, RANDOMIZE... -cycle. This can take up to 5 minutes."
         Top             =   720
         Width           =   1455
      End
      Begin VB.OptionButton QuickSearch 
         Caption         =   "Quick Search"
         Height          =   195
         Left            =   240
         TabIndex        =   1
         ToolTipText     =   "Finds only INITIALIZED (once found before) ballasts"
         Top             =   360
         Value           =   -1  'True
         Width           =   1335
      End
   End
   Begin VB.Label Ballastsfound 
      Caption         =   "0"
      Height          =   255
      Left            =   1800
      TabIndex        =   8
      Top             =   1920
      Width           =   615
   End
   Begin VB.Label Label2 
      Caption         =   "Total of Ballasts found:"
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   1920
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "If a Quick Search does not find all Ballasts, run a Full Search."
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   2160
      Width           =   4335
   End
End
Attribute VB_Name = "SearchForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private iStepCount As Integer

Private Sub CancelSearch_Click()
  Unload Me
End Sub

Private Sub StartSearch_Click()
  MainForm.ClearGrid
  BallastGrid.Update
  DoEvents
  If QuickSearch.Value = True Then
    DoQuickSearch
  Else
    If FullSearch.Value = True Then
      DoFullSearch
    Else
      DoPhysSearch
    End If
  End If
  BallastGrid.Update 'paolo to avoid double search
  Unload Me
End Sub

Private Sub DoPhysSearch()
  Dim found, exitloop As Boolean
  Dim shortrun As Byte
  
  SearchForm.Visible = False
  DoEvents
  
  MsgBox "Search by Physical Selection queries for Ballasts" & Chr(10) & _
         "that are selected by means of a seperate Switch" & Chr(10) & _
         "attached to it (for example)." & Chr(10) & Chr(10) & _
         "NOTE: Only ONE Ballast should be selected at a Time!"
  WaitForm.WaitFor "Waiting for a selected Ballast..."
  DALIBus.Send DALI_Initialize
  DALIBus.Send DALI_PhysicalSelection
  exitloop = False
  shortrun = 0
  Do
    Do
      DoEvents
      DALIBus.SupressErrors
      If DALIBus.Send(DALI_QueryShortAddress) = DALI_A_ERR_NoAnswer Then
        found = False
      Else
        found = True
      End If
    Loop While (Not WaitForm.hasCanceled) And (Not found)
    If found Then
      DALIBus.ProgramNewShort DALIBus.Send(DALI_QueryShortAddress), shortrun
      If MsgBox("Found Ballast has been assigned the short address " & shortrun & "." & Chr(10) & _
                "Continue searching for the next?", vbYesNo) = vbNo Then
        exitloop = True
      End If
      shortrun = shortrun + 1
    Else
      exitloop = True
    End If
  Loop Until exitloop
  WaitForm.WaitDone
  DALIBus.Terminate
End Sub

Private Sub DoQuickSearch()
  Dim iShortRun As Byte
  Dim iNewShortRun As Byte
  
  SearchBar.Max = 63
  If DALIBus.IsBoardOnline Then
    iShortRun = 0
    iNewShortRun = 0
    For iShortRun = 0 To 63
      SearchBar.Value = iShortRun
      If DALIBus.TestShort(iShortRun) Then
        MainForm.SetStatus "Ballast found!"
        'If Not (iShortRun = iNewShortRun) Then
        '  DALIBus.ProgramNewShort iShortRun, iNewShortRun
        'End If
        DALIBus.TestShort iNewShortRun
        DALIBus.TestShort iNewShortRun
        DALIBus.TestShort iShortRun
        DALIBus.TestShort iShortRun
        MainForm.DALIBals.Add DALI_AD_SHORT + iNewShortRun
       'If Not (iShortRun = iNewShortRun) Then
         MainForm.DALIBals.Item(iNewShortRun).ShortAddress = iShortRun
       'End If
        iNewShortRun = iNewShortRun + 1
        Ballastsfound.Caption = iNewShortRun
      End If
    Next iShortRun
    BallastGrid.Update
    MainForm.SetStatus iNewShortRun & " Ballast(s) found."
  Else
    DALIBus.CheckComm
    Unload Me
    DoEvents
  End If
End Sub

Public Property Let StepCount(newsc As Byte)
  iStepCount = newsc
  SearchBar.Value = newsc
End Property

Public Property Get StepCount() As Byte
  StepCount = iStepCount
End Property

Private Sub DoFullSearch()
  Dim Shorts As Byte
    
  Shorts = 0
  SearchBar.Max = 24
  DALIBus.Initialize
  Do While DALIBus.Find(Shorts)
    MainForm.DALIBals.Add DALI_AD_SHORT + Shorts
    MainForm.DALIBals.Item(Shorts).ShortAddress = Shorts 'paolo to apdate the number of slave
    Shorts = Shorts + 1
    Ballastsfound.Caption = Shorts
  Loop
  DALIBus.Terminate
  BallastGrid.Update
End Sub
