VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "TDALIBalBunch"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Holds all the Selected Ballasts"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Collection" ,"TDALIBallast"
Attribute VB_Ext_KEY = "Member0" ,"TDALIBallast"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private mCol As Collection

Public Property Get LightLevel() As Byte
  If mCol.Count = 0 Then
    LightLevel = 0
  Else
    LightLevel = mCol(0).LightLevel
  End If
End Property

Public Property Let LightLevel(newll As Byte)
  Dim i As TDALIBallast
  
  If mCol.Count = MainForm.DALIBals.Count Then 'Broadcast
    DALIBus.Send DALI_DirectArcPowerControl, DALI_AD_BROADCAST, newll
    For Each i In mCol
      i.SetLightLevelNoDALI newll
    Next i
  Else
    For Each i In mCol
      i.LightLevel = newll
    Next i
  End If
  'BallastGrid.Update
End Property

Public Function DimDown()
  Dim i As TDALIBallast
  For Each i In mCol
    i.DimDown
  Next i
End Function

Public Function DimUp()
  Dim i As TDALIBallast
  For Each i In mCol
    i.DimUp
  Next i
End Function

Public Sub Add(Index As Byte)
  MainForm.DALIBals.Item(Index).Selected = True
  mCol.Add MainForm.DALIBals.Item(Index), "Ballast" & Index
End Sub

Public Sub Clear()
  Set mCol = Nothing
  Set mCol = New Collection
End Sub

Public Property Get Item(vntIndexKey As Variant) As TDALIBallast
Attribute Item.VB_UserMemId = 0
  Set Item = mCol(vntIndexKey)
End Property

Public Property Get Count() As Long
    Count = mCol.Count
End Property

Public Sub Remove(Index As Byte)
  mCol.Item("Ballast" & Index).Selected = False
  mCol.Remove ("Ballast" & Index)
End Sub


Public Property Get NewEnum() As IUnknown
Attribute NewEnum.VB_UserMemId = -4
Attribute NewEnum.VB_MemberFlags = "40"
    Set NewEnum = mCol.[_NewEnum]
End Property


Private Sub Class_Initialize()
    Set mCol = New Collection
End Sub


Private Sub Class_Terminate()
    Set mCol = Nothing
End Sub

