

;  Interrupt Vector Configuration
    irq     0   iAD_Converter
    irq     5   iI2C


;  ********* User Defined Variables *********
;       NAME -> REG
;  ------------------------------------------
;   I2Cindex -> 255 
;    NumConv -> 254 
;      RxERR -> 253 
;        SR1 -> 252 
;        SR2 -> 251 
;    command -> 250 
;      data0 -> 248 249 
;      data1 -> 246 247 
;      data2 -> 244 245 
;      data3 -> 242 243 
;      data4 -> 240 241 
;      data5 -> 238 239 
;      data6 -> 236 237 
;      data7 -> 234 235 
;      data8 -> 232 233 
;  direction -> 231 
;       info -> 230 
;       swap -> 229 
;  ******************************************



;  ********** Start procedure "main"
main:
;  Asm Block : inlineAsm
    opt     48  0   0   
;  Asm Block : inlineAsm
    opt     48  1   0   
;  Asm Block : inlineAsm
    opt     48  2   20  
;  Asm Block : inlineAsm
    opt     48  3   0   
;  Asm Block : inlineAsm
    opt     48  4   170 
;  Asm Block : inlineAsm
    opt     48  5   0   
;  Asm Block : inlineAsm
    opt     48  6   0   
;  Asm Block : inlineAsm
    opt     48  7   0   
    ldci    2   250 
    ldci    3   198 
    ldci    4   136 
    ldci    7   0   
    ldci    8   234 
    ldci    47  5   
    ldci    9   0   
    ldci    10  32  
    ldci    11  0   
    ldci    1   0   
    ldci    12  0   
    ldci    13  32  
    ldci    16  20  
    ldci    17  137 
    ldci    18  200 
    ldci    19  0   
    ldci    24  0   
    ldci    25  3   
    ldci    26  3   
    ldci    27  3   
    ldci    28  0   
    ldci    29  0   
    ldci    30  0   
    ldci    31  255 
    ldci    32  192 
    ldci    33  0   
    ldci    34  3   
    ldci    35  0   
    ldpi    9   255 
    ldpi    10  255 
    ldpi    13  255 
    ldpi    14  255 

Begin_While:
Body_While:
    call    Main_Program
    jp      Begin_While










Main_Program:

Start:

I2C_0:
    ldci    16  32  
    ldci    16  52  

ADConverter_0:
    ldci    47  5   
    ldci    8   239 

Code0:
    ldpi    2   1   
    ldrc    255 0   

IrqUnMask:
    ldci    0   33  

Wait0:
;  Asm Block : inlineAsm
    waiti   
    jp      Wait0









iAD_Converter:
    push    32  

Code3:
    ldri    32  42  
    add     249 32  
    addic   248 0   
    ldri    32  44  
    add     247 32  
    addic   246 0   
    ldri    32  46  
    add     245 32  
    addic   244 0   
    ldri    32  48  
    add     243 32  
    addic   242 0   
    ldri    32  50  
    add     241 32  
    addic   240 0   
    ldri    32  52  
    add     239 32  
    addic   238 0   
    ldri    32  54  
    add     237 32  
    addic   236 0   
    ldrr    234 254 
    inc     254 
    cpi     254 66  
    jpnz    End_If_16
endCmp:
    ldci    47  5   
    ldci    8   238 
    ldrc    254 0   

End_If_16:

RetI0:


end_iAD_Converter:
    pop     32  
    reti    





iI2C:
    push    32  

Read_SR_regs:
    ldri    252 7   
    ldri    251 8   
    ldcnf   229 16  
    inc     255 

Stop_Detect:
    mtest   251 8   
    jpz     End_If

or_y:
    jp      Tx_SlaveADD

End_If:

ACK_Failure:
    mtest   251 16  
    jpz     End_If_1

or_y_1:
    jp      I2C_reinit

End_If_1:

SlaveADD:
    mtest   252 4   
    jpz     End_If_2

or_y_2:
    jp      Code4

End_If_2:

Code5:
    ldri    250 6   
    cpi     250 123 
    jpz     End_If_13
endCmp_1:
    inc     230 
    mtest   230 1   
    jpz     No_If_12

or_y_3:
    cpi     230 17  
    jpnz    No_If_3
endCmp_2:
    ldpi    6   99  
    jp      End_If_3

No_If_3:
    ldpr    6   230 

End_If_3:
    jp      End_If_12

No_If_12:
    cpi     230 2   
    jpnz    No_If_11
endCmp_3:
    ldpr    6   248 
    jp      End_If_11

No_If_11:
    cpi     230 4   
    jpnz    No_If_10
endCmp_4:
    ldpr    6   246 
    jp      End_If_10

No_If_10:
    cpi     230 6   
    jpnz    No_If_9
endCmp_5:
    ldpr    6   244 
    jp      End_If_9

No_If_9:
    cpi     230 8   
    jpnz    No_If_8
endCmp_6:
    ldpr    6   242 
    jp      End_If_8

No_If_8:
    cpi     230 10  
    jpnz    No_If_7
endCmp_7:
    ldpr    6   240 
    jp      End_If_7

No_If_7:
    cpi     230 12  
    jpnz    No_If_6
endCmp_8:
    ldpr    6   238 
    jp      End_If_6

No_If_6:
    cpi     230 14  
    jpnz    No_If_5
endCmp_9:
    ldpr    6   236 
    jp      End_If_5

No_If_5:
    cpi     230 16  
    jpnz    End_If_4
endCmp_10:
    ldpr    6   234 

End_If_4:

End_If_5:

End_If_6:

End_If_7:

End_If_8:

End_If_9:

End_If_10:

End_If_11:

End_If_12:

End_If_13:

RetI2:
    jp      end_iI2C

Code4:
    ldri    231 6   
    andi    231 1   
    cpi     231 1   
    jpnz    End_If_15
endCmp_11:
    cpi     250 123 
    jpnz    No_If_14
endCmp_12:
    ldpi    6   200 
    ldrc    230 0   
    ldrc    249 0   
    ldrc    248 0   
    ldrc    247 0   
    ldrc    246 0   
    ldrc    245 0   
    ldrc    244 0   
    ldrc    243 0   
    ldrc    242 0   
    ldrc    241 0   
    ldrc    240 0   
    ldrc    239 0   
    ldrc    238 0   
    ldrc    237 0   
    ldrc    236 0   
    ldrc    235 0   
    ldrc    234 0   
    ldrc    254 0   
    ldci    47  5   
    ldci    8   239 
    jp      End_If_14

No_If_14:
    ldpi    6   90  

End_If_14:

End_If_15:
    jp      RetI2

I2C_reinit:
    ldri    251 8   
    ldcnf   32  16  
    ori     32  2   
    ldcr    16  32  
    ldcnf   32  16  
    andi    32  253 
    ldcr    16  32  
    ldri    32  2   
    ori     32  3   
    ldpr    2   32  
    ldrc    253 0   
    ldri    32  2   
    andi    32  252 
    ldpr    2   32  

RetI1:
    jp      end_iI2C

Tx_SlaveADD:
    jp      RetI1

end_iI2C:
    pop     32  
    reti    



