VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "comctl32.ocx"
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Begin VB.Form frmConformity 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Conformity Test Procedures"
   ClientHeight    =   6375
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   6615
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6375
   ScaleWidth      =   6615
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer timMultiThreading 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   480
      Top             =   3360
   End
   Begin VB.Timer timConf 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   1680
      Top             =   3480
   End
   Begin ComctlLib.ProgressBar ProgressBar1 
      Align           =   2  'Align Bottom
      Height          =   180
      Left            =   0
      TabIndex        =   8
      Top             =   6195
      Width           =   6615
      _ExtentX        =   11668
      _ExtentY        =   318
      _Version        =   327682
      Appearance      =   1
   End
   Begin RichTextLib.RichTextBox RecordBox 
      Height          =   2175
      Left            =   120
      TabIndex        =   7
      Top             =   3960
      Width           =   6375
      _ExtentX        =   11245
      _ExtentY        =   3836
      _Version        =   393217
      Enabled         =   -1  'True
      ScrollBars      =   2
      TextRTF         =   $"frmConformity.frx":0000
   End
   Begin VB.CommandButton Cancel 
      Caption         =   "Cancel"
      Height          =   495
      Left            =   4800
      TabIndex        =   5
      Top             =   3360
      Width           =   1575
   End
   Begin VB.CommandButton RUN 
      Caption         =   "Run Test"
      Height          =   495
      Left            =   3120
      TabIndex        =   4
      Top             =   3360
      Width           =   1575
   End
   Begin VB.CheckBox chkRunPhys 
      Caption         =   "Run Test Sequence 'Physical Address Allocation'"
      Height          =   375
      Left            =   240
      TabIndex        =   2
      Top             =   1200
      Value           =   1  'Checked
      Width           =   6135
   End
   Begin VB.CheckBox chkRunConfig 
      Caption         =   "Run Test Sequence 'Configuration Commands'"
      Height          =   375
      Left            =   240
      TabIndex        =   1
      Top             =   720
      Value           =   1  'Checked
      Width           =   6015
   End
   Begin VB.CheckBox chkRunARC 
      Caption         =   "Run Test Sequence 'ARC Power Control Commands'"
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Value           =   1  'Checked
      Width           =   6015
   End
   Begin VB.Label lblWait 
      Alignment       =   2  'Center
      Height          =   255
      Left            =   0
      TabIndex        =   9
      Top             =   5520
      Width           =   6615
   End
   Begin VB.Label Label2 
      Caption         =   $"frmConformity.frx":006E
      Height          =   855
      Left            =   240
      TabIndex        =   6
      Top             =   2160
      Width           =   6135
   End
   Begin VB.Label Label1 
      Caption         =   $"frmConformity.frx":018D
      Height          =   375
      Left            =   240
      TabIndex        =   3
      Top             =   1680
      Width           =   6135
   End
End
Attribute VB_Name = "frmConformity"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private waitmins, waitsecs As Integer
Private isTimerDone As Boolean

Private Sub Log(Text$)
  RecordBox.SelText = Text
  RecordBox.SelStart = &HFFFFFF
End Sub

Private Sub LogNL(Text$)
  RecordBox.SelText = Text & Chr(10)
  RecordBox.SelStart = &HFFFFFF
End Sub

Private Sub LogCmd(cmd As TDALICommand)
  Log "  [" & DALIBus.GetDescr(cmd) & "]"
End Sub

Private Sub LogCmdNL(cmd As TDALICommand)
  LogNL "  [" & DALIBus.GetDescr(cmd) & "]"
End Sub


Private Sub ClearLog()
  RecordBox.Text = ""
End Sub

Private Sub WaitTimer(mins As Integer, seks As Integer)
  isTimerDone = False
  waitmins = mins
  waitsecs = seks
  timConf.Enabled = True
  Do
    DoEvents
  Loop Until isTimerDone
End Sub


Private Sub Cancel_Click()
  ' stop processing...
  Unload Me
End Sub

Private Sub RUN_Click()
  timMultiThreading.Enabled = True
End Sub

Private Sub timMultiThreading_Timer()
  If chkRunARC.Value = 1 Then
    RunARCTest
  End If
  If chkRunConfig.Value = 1 Then
    RunConfig
  End If
  If chkRunPhys.Value = 1 Then
    RunPhys
  End If
  timMultiThreading.Enabled = False
End Sub

Private Sub DALI(cmd As TDALICommand, Optional addr As TDALIAddress = DALI_AD_BROADCAST, Optional data As Byte = 0)
  If data = 0 Then
    LogCmdNL cmd
  Else
    LogCmd cmd
    LogNL "  (" & data & ")"
  End If
  DALIBus.Send cmd, addr, data
End Sub

Private Function DALIA(cmd As TDALICommand, Optional addr As TDALIAddress = DALI_AD_BROADCAST, Optional data As Byte = 0) As Variant
  Dim zwres As Variant
  
  LogCmd cmd
  Log " -- "
  zwres = DALIBus.Send(cmd, addr, data)
  LogNL "" & zwres
  DALIA = zwres
End Function

Private Function DALIM(cb1 As Byte, cb2 As Byte, flags As TDALICommandFlags, Optional Answer As TDALICommandAnswer = DALICA_OK)
  DALIBus.SendManual cb1, cb2, flags, Answer
End Function


Private Sub RunARCTest()

End Sub

Private Sub RunConfig()
  Dim PHYS_MIN As Byte
  
  PHYS_MIN = DALIA(DALI_QueryPhysicalMinLevel)
  LogNL "2.0 Running Test Sequences 'Configuration Commands'"
    LogNL ""
    LogNL "2.1 Command 151 'Query Version Number' (in Appendix 2.1)"
      DALI DALI_Reset
      DALIA DALI_QueryVersionNumber
      LogNL "Done, no errors."
      LogNL ""
    LogNL "2.2 Test of 100ms Time-Out"
      DALI DALI_Reset
      DALI DALI_StepDown
      LogCmd DALI_Reset
      LogNL "  (1st)"
       DALIM 255, 32, DALICD_NORMAL 'Reset (1x)
      LogNL "  Waiting 200ms..."
      timConf.Interval = 200
      WaitTimer 0, 0
      LogCmd DALI_Reset
      LogNL "  (2nd)"
       DALIM 255, 32, DALICD_NORMAL 'Reset 1x
      timConf.Interval = 300
      WaitTimer 0, 0
      If DALIA(DALI_QueryResetState) Then
        LogNL "Error, FALSE expected."
        'MsgBox "Error in Routine 2.2 of Config commands"
      Else
        LogNL "Done, no errors."
      End If
      LogNL ""
    LogNL "2.3 Test of 'other command' between the config transaction"
      DALI DALI_Reset
      DALI DALI_SetDTR, data:=229
      LogCmd DALI_StoreDTRAsMaxLevel
      LogNL "  (1st)"
       DALIM 255, 42, DALICD_WAIT 'store dtr as max
      LogCmdNL DALI_StepDown
       DALIM 255, 4, DALICD_WAIT 'Step down
      LogCmd DALI_StoreDTRAsMaxLevel
      LogNL "  (2nd)"
       DALIM 255, 42, DALICD_NORMAL 'store dtr as max
      If DALIA(DALI_QueryMaxLevel) = 254 Then
      Else
        LogNL "Error: 254 expected."
        'MsgBox "Error in Routine 2.3 of Config Commands (Error #1)"
      End If
      
      LogCmd DALI_StoreDTRAsMaxLevel
      LogNL "  (1st)"
       DALIM 255, 42, DALICD_WAIT
      LogCmdNL DALI_StepDown
       DALIM 1, 4, DALICD_WAIT
      LogCmd DALI_StoreDTRAsMaxLevel
      LogNL "  (2nd)"
       DALIM 255, 42, DALICD_NORMAL
      If DALIA(DALI_QueryMaxLevel) = 229 Then
      Else
        LogNL "Error: 229 expected."
        'MsgBox "Error in Routine 2.3 of Config Commands (Error #2)"
      End If
      If DALIA(DALI_QueryActualLevel) = 229 Then
        LogNL "Done, no errors."
      Else
        LogNL "Error: 229 expected."
        'MsgBox "Error in Routine 2.3 of Config Commands (Error #3)"
      End If
      LogNL ""
    LogNL "2.4 Command 32 'RESET'"
      DALI DALI_Off
      DALI DALI_Reset
      If (DALIA(DALI_QueryStatus) And &HB8) = &H20 Then
        LogNL "Done, no errors."
      Else
        LogNL "Error: Reset State expected."
        'MsgBox "Error in Routine 2.4 of config Commands"
      End If
      LogNL ""
    LogNL "2.5 Command 33 'STORE ACTUAL LEVEL IN THE DTR"
      DALI DALI_Reset
      DALI DALI_DirectArcPowerControl, data:=254
      timConf.Interval = 500
      WaitTimer 0, 0
      DALI DALI_StoreActLevelToDTR
      'timConf.Interval = 500
      'WaitTimer 0, 0
      If Not (DALIA(DALI_QueryContentDTR) = 254) Then
        LogNL "Error: 254 expected."
      End If
      DALI DALI_DirectArcPowerControl, data:=PHYS_MIN
      timConf.Interval = 500
      WaitTimer 0, 0
      DALI DALI_StoreActLevelToDTR
      'timConf.Interval = 500
      'WaitTimer 0, 0
      If Not (DALIA(DALI_QueryContentDTR) = PHYS_MIN) Then
        LogNL "Error: PHYS_MIN (=" & PHYS_MIN & ") expected."
      End If
      DALI DALI_DirectArcPowerControl, data:=0
      'timConf.Interval = 500
      'WaitTimer 0, 0
      DALI DALI_StoreActLevelToDTR
      timConf.Interval = 500
      WaitTimer 0, 0
      If Not (DALIA(DALI_QueryContentDTR) = PHYS_MIN) Then
        LogNL "Error: 0 expected."
      End If
      LogNL ""
      
       
End Sub

Private Sub RunPhys()

End Sub

Private Sub timConf_Timer()
  If waitsecs = 0 Then
    If waitmins = 0 Then
      lblWait.Caption = ""
      timConf.Enabled = False
      isTimerDone = True
      Exit Sub
    Else
      waitsecs = 59
      waitmins = waitmins - 1
    End If
  Else
    waitsecs = waitsecs - 1
  End If
  lblWait.Caption = "Wait Time: " & waitmins & ":" & waitsecs
End Sub

