

;  Interrupt Vector Configuration
    irq     0   iAD_Converter
    irq     5   iI2C


;  ********* User Defined Variables *********
;        NAME -> REG
;  ------------------------------------------
;    I2Cindex -> 255 
;     NumConv -> 254 
;       RxERR -> 253 
;         SR1 -> 252 
;         SR2 -> 251 
;     command -> 250 
;  commandAck -> 249 
;       data0 -> 247 248 
;       data1 -> 245 246 
;       data2 -> 243 244 
;       data3 -> 241 242 
;       data4 -> 239 240 
;       data5 -> 237 238 
;       data6 -> 235 236 
;       data7 -> 233 234 
;       data8 -> 231 232 
;   direction -> 230 
;           i -> 229 
;        info -> 228 
;        swap -> 227 
;  ******************************************



;  ********** Start procedure "main"
main:
;  Asm Block : inlineAsm
    opt     48  0   0   
;  Asm Block : inlineAsm
    opt     48  1   0   
;  Asm Block : inlineAsm
    opt     48  2   20  
;  Asm Block : inlineAsm
    opt     48  3   0   
;  Asm Block : inlineAsm
    opt     48  4   170 
;  Asm Block : inlineAsm
    opt     48  5   0   
;  Asm Block : inlineAsm
    opt     48  6   0   
;  Asm Block : inlineAsm
    opt     48  7   0   
    ldci    2   250 
    ldci    3   198 
    ldci    4   136 
    ldci    7   0   
    ldci    8   234 
    ldci    47  5   
    ldci    9   16  
    ldci    10  48  
    ldci    11  0   
    ldci    1   0   
    ldci    12  16  
    ldci    13  48  
    ldci    16  5   
    ldci    17  137 
    ldci    18  200 
    ldci    19  0   
    ldci    24  0   
    ldci    25  3   
    ldci    26  3   
    ldci    27  3   
    ldci    28  0   
    ldci    29  0   
    ldci    30  0   
    ldci    31  255 
    ldci    32  192 
    ldci    33  0   
    ldci    34  3   
    ldci    35  0   
    ldpi    9   255 
    ldpi    10  255 
    ldpi    13  255 
    ldpi    14  255 

Begin_While:
Body_While:
    call    Main_Program
    jp      Begin_While










Main_Program:

Start:

I2C_0:
    ldci    16  32  
    ldci    16  37  

Code0:
;  Asm Block : inlineAsm
    ldci    47  5   
    ldrc    255 0   
    ldrc    249 0   

IrqUnMask:
    ldci    0   33  

IrqPriority_0:
    ldci    2   250 
    ldci    3   52  
    ldci    4   69  

Wait0:
;  Asm Block : inlineAsm
    waiti   
    jp      Wait0



















iAD_Converter:
    push    32  

Code3:
    ldri    32  42  
    add     248 32  
    addic   247 0   
    ldri    32  44  
    add     246 32  
    addic   245 0   
    ldri    32  46  
    add     244 32  
    addic   243 0   
    ldri    32  48  
    add     242 32  
    addic   241 0   
    ldri    32  50  
    add     240 32  
    addic   239 0   
    ldri    32  52  
    add     238 32  
    addic   237 0   
    ldri    32  54  
    add     236 32  
    addic   235 0   
    ldri    32  56  
    add     234 32  
    addic   233 0   
    inc     254 
    ldri    32  2   
    xori    32  1   
    ldpr    2   32  
    cpi     254 0   
    jpnz    End_If_18
endCmp:
;  Asm Block : inlineAsm
    ldci    8   238 
    ldrc    254 0   

End_If_18:

RetI0:


end_iAD_Converter:
    pop     32  
    reti    





iI2C:
    push    32  

Read_SR_regs:
    ldri    252 7   
    ldri    251 8   
    ldcnf   227 16  
    ldcr    16  227 
    inc     255 
;  For Initialization
    ldrc    229 1   

Begin_For:
;  Evaluate Condition
    cpi     229 255 
    jpns    End_For
;  Execute Body

EndBody_For:
;  Increment and restart
    inc     229 
    jp      Begin_For

End_For:

Stop_Detect:
    mtest   251 8   
    jpz     End_If

or_y:
    jp      Tx_SlaveADD

End_If:

ACK_Failure:
    mtest   251 16  
    jpz     End_If_1

or_y_1:
    jp      I2C_reinit

End_If_1:

SlaveADD:
    mtest   252 4   
    jpz     End_If_2

or_y_2:
    jp      Code4

End_If_2:

Code5:
    ldri    250 6   
    cpi     249 0   
    jpz     End_If_13
endCmp_1:
    inc     228 
    mtest   228 1   
    jpz     No_If_12

or_y_3:
    cpi     228 17  
    jpnz    No_If_3
endCmp_2:
    ldpi    6   99  
    ldrc    249 0   
    jp      End_If_3

No_If_3:
    ldpr    6   228 

End_If_3:
    jp      End_If_12

No_If_12:
    cpi     228 2   
    jpnz    No_If_11
endCmp_3:
    ldpr    6   247 
    jp      End_If_11

No_If_11:
    cpi     228 4   
    jpnz    No_If_10
endCmp_4:
    ldpr    6   245 
    jp      End_If_10

No_If_10:
    cpi     228 6   
    jpnz    No_If_9
endCmp_5:
    ldpr    6   243 
    jp      End_If_9

No_If_9:
    cpi     228 8   
    jpnz    No_If_8
endCmp_6:
    ldpr    6   241 
    jp      End_If_8

No_If_8:
    cpi     228 10  
    jpnz    No_If_7
endCmp_7:
    ldpr    6   239 
    jp      End_If_7

No_If_7:
    cpi     228 12  
    jpnz    No_If_6
endCmp_8:
    ldpr    6   237 
    jp      End_If_6

No_If_6:
    cpi     228 14  
    jpnz    No_If_5
endCmp_9:
    ldpr    6   235 
    jp      End_If_5

No_If_5:
    cpi     228 16  
    jpnz    End_If_4
endCmp_10:
    ldpr    6   233 

End_If_4:

End_If_5:

End_If_6:

End_If_7:

End_If_8:

End_If_9:

End_If_10:

End_If_11:

End_If_12:

End_If_13:

RetI2:
    jp      end_iI2C

Code4:
    ldri    230 6   
    andi    230 1   
    cpi     230 1   
    jpnz    End_If_17
endCmp_11:
    cpi     250 123 
    jpnz    No_If_16
endCmp_12:
    ldrc    249 123 
    ldpi    6   200 
    ldrc    228 0   
    ldrc    248 0   
    ldrc    247 0   
    ldrc    246 0   
    ldrc    245 0   
    ldrc    244 0   
    ldrc    243 0   
    ldrc    242 0   
    ldrc    241 0   
    ldrc    240 0   
    ldrc    239 0   
    ldrc    238 0   
    ldrc    237 0   
    ldrc    236 0   
    ldrc    235 0   
    ldrc    234 0   
    ldrc    233 0   
    ldrc    254 0   
;  Asm Block : inlineAsm
    ldci    8   239 
    jp      End_If_16

No_If_16:
    cpi     250 100 
    jpnz    No_If_15
endCmp_13:
    ldrc    249 100 
    ldpi    6   200 
    ldrc    228 0   
    ldrc    247 255 
    ldrc    245 255 
    ldrc    243 255 
    ldrc    241 255 
    ldrc    239 255 
    ldrc    237 255 
    ldrc    235 255 
    ldrc    233 255 
    jp      End_If_15

No_If_15:
    cpi     250 119 
    jpnz    No_If_14
endCmp_14:
    ldrc    249 119 
    ldpi    6   200 
    ldrc    228 0   
    ldrc    254 0   
;  Asm Block : inlineAsm
    ldci    8   239 
    jp      End_If_14

No_If_14:
    ldpi    6   90  

End_If_14:

End_If_15:

End_If_16:

End_If_17:
    jp      RetI2

I2C_reinit:
    ldri    251 8   
    ldcnf   32  16  
    ori     32  2   
    ldcr    16  32  
    ldcnf   32  16  
    andi    32  253 
    ldcr    16  32  
    ldrc    253 0   

RetI3:
    jp      end_iI2C

Tx_SlaveADD:
    jp      RetI3

end_iI2C:
    pop     32  
    reti    



