#/********(c) 2003 # STMicroelectronics GmbH **************
#
# Project: 
#
# MODULE: 
# VERSION: 
#
# CREATION DATE: 01.04.03 
# CREATION TIME: 15:32:13 
#
# AUTHOR: PPG 8-bit Micro Application Team
#
#
#
# DESCRIPTION: GNU Makefile for COSMIC ST7 C-Compiler
#
#
# WARNING: THIS FILE IS AUTOMATICALLY CREATED BY A
#          STMicroelectronics TOOL. ALL MODIFICATIONS IN
#          THE OBJECT FILE LIST DONE BY USER WILL BE LOST
#          IF YOU USE THE AUTOMATIC LINKER FILE REFRESHER!
#
#**********************************************************/


# NAME OF APPLICATION:

APPLI_NAME = cosmic
MAKEFILE = $(APPLI_NAME).mak

SRCDIR = ..\..\source
CFGDIR = ..\..\config\cosmic
OBJDIR = ..\..\object


# C-COMPILER:

COMPILER = C:\COSMIC\ST7\cxst7.exe


# OPTIONC FOR C-COMPILER:

C_OPTIONS = +modms -l +debug -i $(SRCDIR) -co $(OBJDIR) -no

CC = $(COMPILER) $(C_OPTIONS)

# LINKER:

LINKER = C:\COSMIC\ST7\clnk.exe


# OPTIONS FOR LINKER:

LINK_OPTIONS = -o $(OBJDIR)\$(APPLI_NAME).st7 -m $(OBJDIR)\$(APPLI_NAME).map


# FORMATER:

HEX = chex


# OPTIONS FOR FORMATER:

HEXOPTIONS = -o $(OBJDIR)\$(APPLI_NAME).s19


# ELF/DWAF FORMATER:

ELFCONV = cvdwarf.exe



#/*****************************************************************
#
# LIST OF C-SOURCE FILES was updated by a STMicroelectronics tool !
#
# LAST UPDATE: 01.04.03 
#              15:33:40 
#
# *****************************************************************/
# C-SOURCE FILE LIST: (don't change this keyword!)

C_SRC = \
        adc_10bit.c \
        auto_wake_up.c \
        clock_reset_supply.c \
        dali.c \
        dali_cmd.c \
        dali_pub.c \
        dali_reg.c \
        eeprom.c \
        flash.c \
        in_circuit_debug.c \
        interrupt_contr.c \
        lite_timer_8bit.c \
        main.c \
        main_clock_contr.c \
        ports.c \
        pwm_ar_timer_12bit.c \
        spi.c \
        trap.c \
        vector.c \
        watchdog_timer.c \

# END (don't delete this keyword!)


# ASSEMBLER SOURCE FILE LIST:

ASM_SRC =


# LIBRARY SOURCE FILE LIST:

LIBS =


# LIST OF DIRCTORIES TO BE SEARCHED:

vpath %.c $(SRCDIR)
vpath %.h $(SRCDIR)
vpath %.h C:\COSMIC\ST7\LIB 
vpath %.o $(OBJDIR)
vpath %   $(CFGDIR2)


# LOCATION OF INCLUDE FILES. DO NOT LEAVE THIS VARIABLE EMPTY
# if you do not need it, remove it or comment it

#INCDIR = ..\..\source


DEP = $(APPLI_NAME).dep


# LIST OF OBJECT FILES:

OBJ_LIST = $(patsubst %.c, %.o,$(C_SRC)) \
	$(patsubst %.asm, %.o,$(ASM_SRC))


# RULE FOR BUILDING THE TARGET:

$(APPLI_NAME).st7 : $(OBJ_LIST) $(LIBS) $(APPLI_NAME).lkf
	@command.com /c ECHO Linking object files ...
	@$(LINKER) $(LINK_OPTIONS) $(CFGDIR)\$(APPLI_NAME).lkf


# RULE FOR MAKING THE HEX FILES

$(APPLI_NAME).s19 : $(APPLI_NAME).st7
	@command.com /c ECHO generate elf format file ...
	@$(ELFCONV) $(OBJDIR)\$(APPLI_NAME).st7
	@command.com /c ECHO generate s19 file...
	@$(HEX) $(HEXOPTIONS) $(OBJDIR)\$(APPLI_NAME).st7



#/*****************************************************************
#
# LIST OF DEPENDENCIES was updated by a STMicroelectronics tool !
#
# LAST UPDATE DEPENDENCIES: 01.04.03 
#              15:33:40 
#
# *****************************************************************/
# RULES FOR MAKING THE OBJECT FILES: (don't change this keyword!)

adc_10bit.o: adc_10bit.c lib.h binary_numbers.h debug.h adc_10bit_hr.h \
 adc_10bit.h

	 $(CC) $(SRCDIR)\adc_10bit.c

auto_wake_up.o: auto_wake_up.c lib.h binary_numbers.h debug.h \
 auto_wake_up_hr.h auto_wake_up.h

	 $(CC) $(SRCDIR)\auto_wake_up.c

clock_reset_supply.o: clock_reset_supply.c lib.h binary_numbers.h debug.h \
 clock_reset_supply_hr.h clock_reset_supply.h

	 $(CC) $(SRCDIR)\clock_reset_supply.c

dali.o: dali.c lib.h binary_numbers.h debug.h dali_hr.h dali.h ports.h \
 dali_cmd.h globals.h

	 $(CC) $(SRCDIR)\dali.c

dali_cmd.o: dali_cmd.c lib.h binary_numbers.h dali.h dali_regs.h dali_cmd.h \
 dali_pub.h lite_timer_8bit.h pwm_ar_timer_12bit_hr.h

	 $(CC) $(SRCDIR)\dali_cmd.c

dali_pub.o: dali_pub.c lib.h binary_numbers.h globals.h dali_pub.h dali_regs.h \
 lite_timer_8bit.h pwm_ar_timer_12bit.h eeprom.h ports.h

	 $(CC) $(SRCDIR)\dali_pub.c

dali_reg.o: dali_reg.c lib.h binary_numbers.h dali_cmd.h dali_regs.h eeprom.h

	 $(CC) $(SRCDIR)\dali_reg.c

eeprom.o: eeprom.c lib.h binary_numbers.h debug.h eeprom_hr.h eeprom.h \
 globals.h dali_regs.h

	 $(CC) $(SRCDIR)\eeprom.c

flash.o: flash.c lib.h binary_numbers.h debug.h flash_hr.h flash.h

	 $(CC) $(SRCDIR)\flash.c

in_circuit_debug.o: in_circuit_debug.c lib.h binary_numbers.h debug.h \
 in_circuit_debug_hr.h in_circuit_debug.h

	 $(CC) $(SRCDIR)\in_circuit_debug.c

interrupt_contr.o: interrupt_contr.c lib.h binary_numbers.h \
 interrupt_contr_hr.h interrupt_contr.h

	 $(CC) $(SRCDIR)\interrupt_contr.c

lite_timer_8bit.o: lite_timer_8bit.c lib.h binary_numbers.h debug.h \
 lite_timer_8bit_hr.h lite_timer_8bit.h dali_pub.h globals.h ports.h

	 $(CC) $(SRCDIR)\lite_timer_8bit.c

main.o: main.c lib.h binary_numbers.h debug.h globals.h ports.h \
 pwm_ar_timer_12bit.h eeprom.h dali.h lite_timer_8bit.h dali_cmd.h dali_regs.h \
 clock_reset_supply.h interrupt_contr.h main_clock_contr.h

	 $(CC) $(SRCDIR)\main.c

main_clock_contr.o: main_clock_contr.c lib.h binary_numbers.h debug.h \
 main_clock_contr_hr.h main_clock_contr.h

	 $(CC) $(SRCDIR)\main_clock_contr.c

ports.o: ports.c lib.h binary_numbers.h debug.h ports_hr.h ports.h globals.h

	 $(CC) $(SRCDIR)\ports.c

pwm_ar_timer_12bit.o: pwm_ar_timer_12bit.c lib.h binary_numbers.h debug.h \
 pwm_ar_timer_12bit_hr.h pwm_ar_timer_12bit.h

	 $(CC) $(SRCDIR)\pwm_ar_timer_12bit.c

spi.o: spi.c lib.h binary_numbers.h debug.h spi_hr.h spi.h

	 $(CC) $(SRCDIR)\spi.c

trap.o: trap.c lib.h binary_numbers.h debug.h trap.h

	 $(CC) $(SRCDIR)\trap.c

vector.o: vector.c

	 $(CC) $(SRCDIR)\vector.c

watchdog_timer.o: watchdog_timer.c lib.h binary_numbers.h debug.h \
 watchdog_timer_hr.h watchdog_timer.h

	 $(CC) $(SRCDIR)\watchdog_timer.c


# END OBJECT FILE RULES (don't delete this keyword!)


# RULE FOR BUILDING PROJECT:

build:
	gmake -f $(APPLI_NAME).mak $(APPLI_NAME).s19


# RULE FOR REBUILDING PROJECT:

rebuild:
	gmake -f $(APPLI_NAME).mak clean


# RULE FOR CLEANING THE APPLICATION:

.PHONY: clean
clean:
	@command.com /c ECHO delete object files ...
	if exist ..\..\object\*.o del ..\..\object\*.o
	if exist ..\..\object\*.ls del ..\..\object\*.ls
	if exist ..\..\object\*.elf del ..\..\object\*.elf
	if exist ..\..\object\*.st7 del ..\..\object\*.st7
	if exist ..\..\object\*.map del ..\..\object\*.map
	gmake -f $(APPLI_NAME).mak $(APPLI_NAME).s19


#/**** END OF FILE *** (c) 2003  STMicroelectronics GmbH **/


