/**************** (c) 2003 STMicroelectronics **********************

PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic

MODULE  :  adc_10bit_hr.h
VERSION :  1

CREATION DATE : 10.2001 

AUTHOR : 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
******************************************************************************/

#ifndef ADC10_HR_H
#define ADC10_HR_H


/*---REGISTERS---*/ 
                                           
#ifdef __CSMC__							/* only for Cosmic Compiler*/
@tiny extern volatile u8 ADCCSR @0x34;	/* ADC Control Status Register */
@tiny extern volatile u8 ADCDRH @0x35;	/* ADC Data Register High */
@tiny extern volatile u8 ADCDRL @0x36;	/* ADC Data Register Low */
#endif

#ifdef __HIWARE__						/* only for HIWARE Compiler*/
#pragma DATA_SEG SHORT ADC
extern volatile u8 ADCCSR;                /* ADC Control Status Register       */
extern volatile u8 ADCDRH;                 /* ADC Data Register high           */
extern volatile u8 ADCDRL;                 /* ADC Data Register low            */
#pragma DATA_SEG DEFAULT
#endif


/*---CONSTANTS---*/

/* ADC Control/Status Register bit definition */

#define EOC         0x07        	/* End of Conversion */
#define SPEED		0x06			/* ADC clock selection */
#define ADON        0x05        	/* A/D converter on */


#endif


/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/

