/**************** (c) 2003 STMicroelectronics **********************

PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic 

MODULE  :  clock_reset_supply_hr.h
VERSION :  1

CREATION DATE : 01.2001

AUTHOR : 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
******************************************************************************/

#ifndef CRS3_HR_H
#define CRS3_HR_H

/*---REGISTERS---*/ 

#ifdef __CSMC__							/* only for Cosmic Compiler*/
@tiny extern u8 RCCR @0x39;			    /* RC Oscillator Control Register 			*/   
@tiny extern volatile u8 SICSR @0x3A;	/* System Integrity Control Status Register */   
#endif  

#ifdef __HIWARE__						/* only for HIWARE Compiler*/
#pragma DATA_SEG SHORT CRS
extern u8 RCCR;							/* RC Oscillator Control Register 			*/   
extern volatile u8 SICSR;				/* System Integrity Control Status Register */   
#pragma DATA_SEG DEFAULT
#endif


/*---CONSTANTS---*/

/* ClOCK, RESET and SUPPLY Register bit definition  */

#define LOCKED      0x03        /* PLL Locked flag */
#define LVDRF       0x02        /* LVD Reset Flag */
#define AVDF        0x01        /* AVD Voltage Detector Flag */
#define AVDIE       0x00        /* AVD Interrupt Enable */

#endif


/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/

