/**************** (c) 2003 STMicroelectronics **********************

PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic
         
MODULE  :  dali.c
VERSION :  3

CREATION DATE : 10.2001

AUTHOR : 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Functions DALI Unit
              
 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

#include "lib.h"
#include "debug.h"
#include "dali_hr.h"
#include "dali.h"
#include "ports.h"         
#include "dali_cmd.h"
#include "globals.h"

volatile u8 dali_address, dali_data, dali_receive_status;
u8 dali_state;

/*-----------------------------------------------------------------------------
ROUTINE NAME : DALI_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the DALI Module

COMMENTS     :
-----------------------------------------------------------------------------*/
void DALI_Init(void)
{
	/* Adapt the DCM data rate according to the CPU frequency */
	if (F_CPU == 8)	DCMCLK = 207;       
	if (F_CPU == 4)	DCMCLK = 103;       
	if (F_CPU == 1)	DCMCLK = 25;        
	
	DCMCSR = b10000000b;	// DALI Interrupt Enable
	DCMCR  = b00001000b;	// Receive Enable
    DCMCSR;					// clear flags
	dali_state = DALI_IDLE;
	dali_receive_status = DALI_READY_TO_RECEIVE;
}
#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : DALI_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : DALI Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/
void DALI_Interrupt(void)
{  
	if (!ValBit(DCMCSR,EF))		// check error flag
	{   
		if (ValBit(DCMCSR,RTF))		// check for receive flag
		{  
			dali_address = DCMFA; 		// read DALI forward address	
			dali_data = DCMFD;		// read DALI forward data;
			dali_receive_status = DALI_NEW_FRAME_RECEIVED;     
		}
		else				// DCM is in transmitt state
		{
			ClrBit (DCMCR,FTS);		// set to receive state
			ClrBit (DCMCR,RTS);		// set to receive state
		} 
	    SetBit(DCMCR,RTA);
	}
	else
	{
    	// error flag handling!!
	}
	
}  /* End of void DALI_Interrupt(void) */


/*-----------------------------------------------------------------------------
ROUTINE NAME : Send_DALI_Frame
INPUT/OUTPUT : None

DESCRIPTION  :

COMMENTS     : 
 ************************************************
 * Initializes Sending but returns immediately!	 *
 * Sending continues asynchronously.             *
 ************************************************
-----------------------------------------------------------------------------*/ 

void Send_DALI_Frame(u8 data)
{	
    DCMCR = b00000000b;
	DCMBD = data;				// put "backward data" into send register
	DCMCR = b00001001b;
	dali_state = DALI_SEND_START;
}
/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/
 


