/**************** (c) 2003 STMicroelectronics **********************

PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic 

MODULE  :  dali.h
VERSION :  2

CREATION DATE : 10.2001

AUTHOR :  8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   File with all the functions used in the other routines. 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
******************************************************************************/

#ifndef DALI_H
#define DALI_H

extern volatile u8 dali_address, dali_data, dali_receive_status;
extern u8 dali_state;

/*---CONSTANTS---*/
/* Constants for dali_state*/
#define DALI_IDLE		0	/* DALI sender: Idle mode */
#define DALI_SEND_START		1	/* DALI sender: send Start Condition */
#define DALI_SEND_ADDRESS	2	/* DALI sender: Send Address Bits*/
#define DALI_SEND_DATA		3	/* DALI sender: Send Data Bits */
#define DALI_SEND_STOP		4	/* DALI sender: Send Stop Bits */
#define DALI_SEND_SETTLING	5       /* DALI sender: Wait Settling Time */
#define DALI_WAIT		6	/* Waiting for Answerframe */

/* Constants for dali_receive_status */
#define DALI_READY_TO_RECEIVE	0
#define DALI_NEW_FRAME_RECEIVED	1                                         
#define DALI_RECEIVE_OVERFLOW	2

#define DALI_REPETITION_WAIT 	120  /*Command repetition timeout (ms)*/
//se 15/01/03: back to 100 (from 120) avec code parfait.
//se 100 before  solves 2124pb, but why?

/** public functions **/

void DALI_Init(void);
void Send_DALI_Frame(u8);

#endif

/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/

