/**************** (c) 2003 STMicroelectronics **********************

PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic

MODULE  :  dali_hr.h
VERSION :  1

CREATION DATE : 10.2001

AUTHOR :  PPG 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
******************************************************************************/

#ifndef DALI_HR_H
#define DALI_HR_H


/*---REGISTERS---*/ 

#ifdef __CSMC__							/* only for Cosmic Compiler*/
@tiny extern volatile u8 DCMCLK @0x040;	/* DALI CLock Register 				*/
@tiny extern volatile u8 DCMFA @0x041;	/* DALI Forward Address Register	*/
@tiny extern volatile u8 DCMFD @0x042;	/* DALI Forward Data Register		*/
@tiny extern volatile u8 DCMBD @0x043;	/* DALI Backward Data Register		*/
@tiny extern volatile u8 DCMCR @0x044;	/* DALI Control Register			*/
@tiny extern volatile u8 DCMCSR @0x045;	/* DALI Control/Status Register 	*/
#endif

#ifdef __HIWARE__						/* only for HIWARE Compiler*/
#pragma DATA_SEG SHORT DALI
extern volatile u8 DCMCLK;				/* DALI CLock Register 				*/
extern volatile u8 DCMFA;				/* DALI Forward Address Register	*/
extern volatile u8 DCMFD;				/* DALI Forward Data Register		*/
extern volatile u8 DCMBD;				/* DALI Backward Data Register		*/
extern volatile u8 DCMCR;				/* DALI Control Register			*/
extern volatile u8 DCMCSR;				/* DALI Control/Status Register 	*/
#pragma DATA_SEG DEFAULT
#endif

/*---CONSTANTS---*/

/* DALI Control Register bit definition  */

#define DCME        0x03        /* DALI Communication Enable			*/
#define RTA         0x02        /* DALI Receive/Transmit Acknowledge	*/
#define RTS         0x01        /* DALI Receive/Transmit State			*/
#define FTS         0x00        /* DALI Force Transmitt State			*/

/* DALI Control Status Register bit definition */

#define ITE			0x07        /* DALI Interrupt Enable				*/
#define IFT			0x06        /* DALI Interrupt Flag					*/
#define EF			0x05        /* DALI Error Flag						*/
#define RTF			0x04        /* DALI Receive/Transmit Flag			*/
                                                                        

#endif

/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/

