/**************** (c) 2003 STMicroelectronics **********************

PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic

MODULE  :  dali_reg.c
VERSION :  2

CREATION DATE : 11.2001 

AUTHOR : 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Dali Register
              
 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

/* Include files */
#include "lib.h" 
#include "debug.h" 

#include "dali_cmd.h"
#include "dali_regs.h"
#include "eeprom.h"

u8 RAMRegs[DALIREG_RAM_END - DALIREG_RAM_START];
u8 short_addr;
u8 randbuf[2];

extern u8 ROMRegs[]; /* Declared in DALI_PUB.C */

#pragma INTO_ROM
const u8 DaliRegDefaults[] =
 {254,
  0xFF,0xFF,0xFF,
  0,

  254,
  254,
  0,
  254,
  7,
  0,
  0,
  0xFF,0xFF,0xFF,
  0,
  0,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,

  0,
  0,
}; 


/*-*-*-*-*-*-*-*/

#define DALIR_IsRAMReg(a) ((a>=DALIREG_RAM_START) && (a<DALIREG_RAM_END))
#define DALIR_IsEEPROMReg(a) ((a>=DALIREG_EEPROM_START) && (a<DALIREG_EEPROM_END))
#define DALIR_IsROMReg(a)  ((a>=DALIREG_ROM_START) && (a<DALIREG_ROM_END))
#define DALIR_IsValid(a) (a < DALI_NUMBER_REGS)

void DALIR_Init(void)
{
  u8 i;
  for (i = 0; i<5; i++) RAMRegs[i]=0;
}

void DALIR_WriteEEPROMReg(u8 idx, u8 val) 
{

  if (idx == DALIREG_SHORT_ADDRESS - DALIREG_EEPROM_START) short_addr = val;
  E2_WriteMem(idx,val);
}

u8 DALIR_ReadEEPROMReg(u8 idx) 
{
  if (idx == DALIREG_SHORT_ADDRESS - DALIREG_EEPROM_START) return short_addr;
  return E2_ReadMem(idx);
}

u8 DALIR_ReadReg(u8 idx)
{
  if (!DALIR_IsValid(idx)) return 0; 
  if (DALIR_IsRAMReg(idx)) { return RAMRegs[idx - DALIREG_RAM_START];}
  if (DALIR_IsROMReg(idx)) { return ROMRegs[idx - DALIREG_ROM_START];}
  return DALIR_ReadEEPROMReg(idx - DALIREG_EEPROM_START);
}

void DALIR_WriteReg(u8 idx, u8 newval) 
{ 		
	u8 i;
	if (!DALIR_IsValid(idx)) return;
	if (DALIR_IsROMReg(idx)) return;
	if (DALIR_IsRAMReg(idx))
    {
	    RAMRegs[idx - DALIREG_RAM_START] = newval;
	} 
	else 
	{
	    DALIR_WriteEEPROMReg(idx - DALIREG_EEPROM_START, newval);
	}

	if (DALIR_ReadStatusBit(DALIREG_STATUS_FADE_READY)==0)
    {
	
		DALIR_WriteStatusBit(DALIREG_STATUS_RESET_STATE,1);   /*set reset State*/
		
		for (i=0; i<DALI_NUMBER_REGS; i++)
        {      		//to refresh "reset state" bit
			switch (i) 
	        {
				case DALIREG_SHORT_ADDRESS:
				    break;
				case DALIREG_STATUS_INFORMATION:
				    break;
				case DALIREG_MIN_LEVEL:
					if (DALIR_ReadReg(DALIREG_MIN_LEVEL)!= DALIR_ReadReg(DALIREG_PHYS_MIN_LEVEL)) 
					DALIR_WriteStatusBit(DALIREG_STATUS_RESET_STATE,0); /*clear reset State*/;
					break;
				default:
					if(DALIR_IsEEPROMReg(i) || DALIR_IsRAMReg(i)) 
					if (DALIR_ReadReg(i) != DaliRegDefaults[i]) 
					DALIR_WriteStatusBit(DALIREG_STATUS_RESET_STATE,0); /*clear reset State*/
					break;
            }
		}
	}
}  

void DALIR_WriteStatusBit(u8 bit,u8 val)
{
	if (val == 0) 
    {
	    ClrBit(RAMRegs[DALIREG_STATUS_INFORMATION - DALIREG_RAM_START],bit);
	} 
    else 
    {
	    SetBit(RAMRegs[DALIREG_STATUS_INFORMATION - DALIREG_RAM_START],bit);
	}
}

u8 DALIR_ReadStatusBit(u8 bit) 
{
    return ValBit(RAMRegs[DALIREG_STATUS_INFORMATION - DALIREG_RAM_START],bit);
}

void DALIR_ResetRegs(void)
{
	u8 i;
	
	E2_WriteBurst(0,DALIREG_EEPROM_END-DALIREG_EEPROM_START,&(DaliRegDefaults[DALIREG_EEPROM_START]));
	E2_WriteMem(DALIREG_SHORT_ADDRESS - DALIREG_EEPROM_START,short_addr);
	for (i=0; i<DALI_NUMBER_REGS; i++)
    {
		switch (i) 
        {
			case DALIREG_SHORT_ADDRESS:
			    break;
			case DALIREG_STATUS_INFORMATION:
			    break;
			case DALIREG_MIN_LEVEL:
			    DALIR_WriteReg(DALIREG_MIN_LEVEL,DALIR_ReadReg(DALIREG_PHYS_MIN_LEVEL));
			    break;
			default:
			    if(DALIR_IsEEPROMReg(i) || DALIR_IsRAMReg(i)) 
                { 
                    DALIR_WriteReg(i,DaliRegDefaults[i]); 
                } 
			    break;
		}
	}
	i=DALIR_ReadReg(DALIREG_STATUS_INFORMATION);
	i&=0x47;
	DALIR_WriteReg(DALIREG_STATUS_INFORMATION, i);
	DALIR_WriteStatusBit(DALIREG_STATUS_RESET_STATE,1); /*Set reset State*/
}

void DALIR_LoadRegsFromE2(void) 
{
    short_addr = E2_ReadMem(DALIREG_SHORT_ADDRESS - DALIREG_EEPROM_START);
}

void DALIR_DeleteShort(void) 
{
	short_addr = 0xFF;
	E2_WriteMem(DALIREG_SHORT_ADDRESS - DALIREG_EEPROM_START,0xFF);
	DALIR_WriteStatusBit(DALIREG_STATUS_MISSING_SHORT,1);
}

/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/
