/**************** (c) 2003 STMicroelectronics **********************

PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic

MODULE  :  eeprom.c
VERSION :  3

CREATION DATE : 11.2001 

AUTHOR : 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : EEPROM Routines

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
MODIFICATIONS :
******************************************************************************/

#include "lib.h"
#include "debug.h"
#include "eeprom_hr.h"
#include "eeprom.h"

#include "globals.h"
#include "dali_regs.h"


/* Write in the memory section EEPROM_VAR */
/* Here the COSMIC way of using the eeprom is not used (see linker file: .lkf) */ 
#ifdef __CSMC__
  #pragma section @near [eeprom_var]  //const {eeprom_var}
  u8 eeprom_variable[125];
#endif                          

#ifdef __HIWARE__						/* only for HIWARE Compiler*/
#pragma DATA_SEG FAR EEPROM_VAR
 u8 eeprom_variable[125];				/* EEPROM Control Register  */
#pragma DATA_SEG DEFAULT
#endif


/* Write back the default memory section */ 
#ifdef __CSMC__
  #pragma section const {}
#endif

#define EEP_Wait_Finished()	while (ValBit(EECSR,E2PGM))
#define EEP_Set_Reading()	ClrBit(EECSR,E2LAT)
#define EEP_Set_Writing()	SetBit(EECSR,E2LAT)
#define EEP_Start_Write()	SetBit(EECSR,E2PGM)    


void E2_ResetEEPROM(void);
void E2_WriteSR(u8);
u8 E2_DetectMemSize(void);
u8 E2_ReadSR(void);

/*-----------------------------------------------------------------------------
ROUTINE NAME : EEPROM_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the EEPROM

COMMENTS     :
-----------------------------------------------------------------------------*/
void EEPROM_Init(void)
{
  EEP_Wait_Finished();
  EEP_Set_Reading();
  if ((eeprom_variable[0]=='T') && (eeprom_variable[1]=='G') && (eeprom_variable[2]==8) && (eeprom_variable[3]==0x00)) 
  { //test on EEPROM content validity see E2_ResetEEPROM()
    DALIR_LoadRegsFromE2();  // short_addr = E2_ReadMem(DALIREG_SHORT_ADDRESS - DALIREG_EEPROM_START);
  } 
  else 
  {
    E2_ResetEEPROM();
    DALIR_DeleteShort();
    DALIR_ResetRegs();
  }
  EEP_Wait_Finished();
  EEP_Set_Reading();
}

void E2_ResetEEPROM(void)
{  
  EEP_Wait_Finished();
  EEP_Set_Writing();
  eeprom_variable[0] = 'T';   //"TG80" is written  in the EEPROM
  eeprom_variable[1] = 'G';   //This allows to check later that the EEPROM content is valid. 
  eeprom_variable[2] = 8;
  eeprom_variable[3] = 0x00;
  EEP_Start_Write();
  EEP_Wait_Finished();
  EEP_Set_Reading();
}

void E2_WriteMem(u8 addr, u8 data)
{
  EEP_Wait_Finished();
  EEP_Set_Writing();
  eeprom_variable[addr+4] = data;
  EEP_Start_Write();
  EEP_Wait_Finished();
  EEP_Set_Reading();
}

void E2_WriteBurst(u8 addr, u8 times, u8 *buf)
{
  u8 address,i;
  EEP_Wait_Finished();
  EEP_Set_Writing();
  address = addr + 4;
  i = 0;
  while (times--) 
  {
    eeprom_variable[address+i] = buf[i];
    i++;
    if (((address+i) & 0x0F) == 0)
    { /* flush the Buffer */
      EEP_Start_Write();	// Flush latches, start new frame
      EEP_Wait_Finished();
      EEP_Set_Writing();        
    }
  }
  EEP_Start_Write();  		
  EEP_Wait_Finished();
  EEP_Set_Reading();
}  

u8 E2_ReadMem(u8 addr)
{
  EEP_Wait_Finished();
  EEP_Set_Reading();
  return eeprom_variable[addr+4];
}


/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/


