/**************** (c) 2003 ST Microelectronics **********************

PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic

MODULE  :  in_circuit_debug_hr.h
VERSION :  1

CREATION DATE : 10.2001

AUTHOR :  8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

#ifndef ICD_HR_H
#define ICD_HR_H


/*---REGISTERS---*/ 
#ifdef __CSMC__							/* only for Cosmic Compiler*/
@tiny extern volatile u8 ICDCR @0x04B;		/* ICD Control Register				*/
@tiny extern volatile u8 ICDSR @0x04C;		/* ICD Status Register				*/
@tiny extern volatile u8 ICDBK1H @0x04D;	/* ICD Breakpoint Register 1 High	*/
@tiny extern volatile u8 ICDBK1L @0x04E;	/* ICD Breakpoint Register 1 Low	*/
@tiny extern volatile u8 ICDBK2H @0x04F;	/* ICD Breakpoint Register 2 High	*/
@tiny extern volatile u8 ICDBK2L @0x050;	/* ICD Breakpoint Register 2 Low	*/
#endif

#ifdef __HIWARE__						/* only for HIWARE Compiler*/
#pragma DATA_SEG SHORT ICD
extern volatile u8 ICDCR;				/* ICD Control Register				*/
extern volatile u8 ICDSR;				/* ICD Status Register				*/
extern volatile u8 ICDBK1H;				/* ICD Breakpoint Register 1 High	*/
extern volatile u8 ICDBK1L;				/* ICD Breakpoint Register 1 Low	*/
extern volatile u8 ICDBK2H;				/* ICD Breakpoint Register 2 High	*/
extern volatile u8 ICDBK2L;				/* ICD Breakpoint Register 2 Low	*/
#pragma DATA_SEG DEFAULT
#endif


/*---CONSTANTS---*/

/* ICD Control Register bit definition  */

#define WDGOFF      0x07        /* Watchdog Control Enable				*/
#define MTR         0x06        /* Monitor Control						*/
#define BIR         0x02        /* Break on Read Control				*/
#define BIW         0x01        /* Break on Write Control				*/
#define AIE         0x00        /* Abort Interrupt Enable				*/


/* ICD Status Register bit definition */

#define STEPE		0x06        /* Step by Step enable					*/
#define STEPF		0x05        /* Step by Step Flag					*/
#define RST			0x04        /* Reset Flag							*/
#define BRW			0x03        /* Break on Read/Write Flag				*/
#define BK2F		0x02        /* Breakpoint 2 Flag					*/
#define BK1f		0x01        /* Breakpoint 1 Flag					*/
#define AF			0x00        /* Abort Flag							*/
                                                                        

#endif

/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/

