/**************** (c) 2003 STMicroelectronics **********************

PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic

MODULE  :  lite_timer_8bit.c
VERSION :  1

CREATION DATE : 10.2001 

AUTHOR : 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Functions Timer LITE
              
 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

#include "lib.h"
#include "debug.h"
#include "lite_timer_8bit_hr.h"
#include "lite_timer_8bit.h"     
#include "dali_pub.h"
#include "globals.h"
#include "ports.h" /*SESE to toggle pin */

/* defines */

/* file global variable */
volatile u8 lite_timer_IT_state;
extern volatile u8 Process_Status;

#ifdef __CSMC__			/* test for Cosmic Compiler */
  #define _tiny_ @tiny
#else
	#define _tiny_
#endif
_tiny_ u16 timercounter;
_tiny_ u8  bigtimermins;
_tiny_ u16 bigtimertics;
_tiny_ u8  RealTimeClock_BigTimer;
_tiny_ u16 RealTimeClock_TimerCountDown;
_tiny_ u8  UserTimerActive;
_tiny_ u16  BusFailureTimer;


/*-----------------------------------------------------------------------------
ROUTINE NAME : Timer_Lite_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the Timer Lite

COMMENTS     :
-----------------------------------------------------------------------------*/
void Timer_Lite_Init(void)
{
//  LTCSR1 = b00010000b;		/* Lite Timer Control Status Register 1 */

  LTCSR2 = b00000010b;		/* Lite Timer Control Status Register 2 */ 

/* Adapt the timer value according to the CPU frequency */
if (F_CPU == 8)	LTARR = (255-250);       //SE_FCPU
if (F_CPU == 4)	LTARR = (255-125);       //SE_FCPU
if (F_CPU == 1)	LTARR = (255-31);        //SE_FCPU  
}


#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif

/*-----------------------------------------------------------------------------
ROUTINE NAME : LITE_TIMER_RTC_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : timer Lite Real Time Clock Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void LITE_TIMER_RTC_Interrupt(void)
{

}

void RTC_LaunchBigTimer(u8 mins)
{
  bigtimertics = 60000; /* 60000*1ms=1mn*/
  bigtimermins = mins-1; /* Timer is launched for (mins-1)*1mn (basically 15mn, see DALI specifications)*/
  RealTimeClock_BigTimer = 1;
}

void RTC_LaunchTimer(u16 timer_value)
{
  RealTimeClock_TimerCountDown=timer_value;
}


void RTC_LaunchUserTimer(u8 TimerCount)
{
  UserTimerActive=TimerCount;
}

void RTC_DoneUserTimer(void)
{
  UserTimerActive=0;
}

void RTC_LaunchBusFailureTimer(void)
{
  BusFailureTimer=500; /* 500 ms */
}

void RTC_DoneBusFailureTimer(void)
{
  BusFailureTimer=0;
}

void RTC_ProcessBusFailureTimer(void)
{

    BusFailureTimer=BusFailureTimer-1;
	if (BusFailureTimer==0)
    {
	    Process_Status=3;
	}
}


void Process_Lite_timer_IT(void)
{
	if (UserTimerActive)
	{	
	  
	  if (UserTimerActive!=0xFF) UserTimerActive--;
	  DALIP_TimerCallback();	  
	  if (UserTimerActive==0)
      {
	      DALIP_SetFadeReadyFlag(0); /* fade is ready */
	  }
	  	  
	}
    lite_timer_IT_state=0;
}



#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif


/*-----------------------------------------------------------------------------
ROUTINE NAME : LITE_TIMER_RTC2_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : timer Lite Real Time Clock 2 Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void LITE_TIMER_RTC2_Interrupt(void)
{
  if (ValBit(LTCSR2,TB2F))	
  { 
	if (bigtimertics) 
	{
	  bigtimertics--;
	}
	else
	{
	  if (bigtimermins) 
	  {
		bigtimermins--;
		bigtimertics = 60000;  /* 60000*1ms=1mn*/
	  }
	  else
	  {
		RealTimeClock_BigTimer = 0;
	  }
	}
	if (RealTimeClock_TimerCountDown) 
	{
	  RealTimeClock_TimerCountDown--;
	}
    lite_timer_IT_state=1;
  }
}


/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/