/**************** (c) 2003  STMicroelectronics **********************

PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic

MODULE  :  lite_timer_8bit_hr.h
VERSION :  1

CREATION DATE : 10.2001

AUTHOR :  8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
******************************************************************************/

#ifndef LITE_TIM2_HR_H
#define LITE_TIM2_HR_H


/*---REGISTERS---*/ 
#ifdef __CSMC__					/* only for Cosmic Compiler*/
@tiny extern volatile u8 LTCSR2 @0x08;	/* Lite Timer Control Status Register 2*/
@tiny extern volatile u8 LTARR @0x09;	/* Lite Timer Auto Reload Register     */
@tiny extern volatile u8 LTCNTR @0x0A;	/* Lite Timer Counter Register         */
@tiny extern volatile u8 LTCSR1 @0x0B;	/* Lite Timer Control Status Register 1*/
@tiny extern volatile u8 LTICR @0x0C;	/* Lite Timer Input Capture Register   */
#endif

#ifdef __HIWARE__						/* only for HIWARE Compiler*/
#pragma DATA_SEG SHORT LITE_TIMER
extern volatile u8 LTCSR2;				/* Lite Timer Control Status Register 2 */
extern volatile u8 LTARR;				/* Lite Timer Auto Reload Register      */
extern volatile u8 LTCNTR;				/* Lite Timer Counter Register          */
extern volatile u8 LTCSR1;				/* Lite Timer Control Status Register 1 */
extern volatile u8 LTICR;				/* Lite Timer Input Capture Register    */
#pragma DATA_SEG DEFAULT
#endif

/*---CONSTANTS---*/

/* Lite Timer Control Register 2 bit definition  */

#define TB2IE       0x01        /* Timebase 2 interrupt enable       */ 
#define TB2F        0x00        /* Timebase 2 interrupt flag         */

/* Lite Timer Control Register bit definition  */

#define ICIE        0x07        /* Input capture interrupt enable       */ 
#define ICF         0x06        /* Input capture flag                   */
#define TB          0x05        /* Timebase Period Selection            */
#define TB1IE       0x04        /* Timebase 1 interrupt enable          */
#define TB1F        0x03        /* Timebase 1 interrupt flag            */

#endif

/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/

