/**************** (c) 2003 STMicroelectronics **********************
          
PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic

MODULE  :  main.c
VERSION :  9

CREATION DATE : 10.2001 

AUTHOR : 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Main Routine
              
 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

/* Include files */

#include "lib.h"        /* Predifined libraries working at bit level */
#include "debug.h"      /* Debugging options */

#include "globals.h"
#include "dali.h" 
#include "dali_hr.h" 

#include "ports.h"
#include "ports_hr.h"

#include "lite_timer_8bit.h" 
#include "pwm_ar_timer_12bit.h"
#include "pwm_ar_timer_12bit_hr.h" //paolo
#include "dali_cmd.h"
#include "dali_regs.h" 
#include "eeprom.h"

#include "clock_reset_supply.h"

#include "interrupt_contr.h" /* Needed for external I/O IT (Wake up for DALI) */

#include "main_clock_contr.h" /*Stef pour voir la clock 7/3/02 debug last PC */


/* ----- Code header section -----
ST is writing some data at the beginning of the code,
in order to give some information about it. A typical appearance is:
"DALIbyST7DALI CT"
"Version SL2 V1.0"
"(c)2001 by ST  D"
This part of the memory is called "version".
Its definition can be found in the linker file (.lkf)
It can be removed if needed.*/

/* -- Write in memory section "version" ans set Compiler option --
This is the beginning of the "version" memory section.
The compiler is COSMIC, so a C will be displayed after DALIbyST7DALI */
#ifdef __CSMC__
  #pragma section const {version}
  #define COMPILER "C"
#endif

#ifdef __HIWARE__
  #define COMPILER "H"
#endif

/* -- Arc table option --
If the arc table mode is enable, a T is to be displayed.
For more information about he arc table mode, please read the documentation */
#ifdef USE_ARC_TABLE
  #define ARC_TYPE "T"
#else  
  #define ARC_TYPE "D"
#endif

/* -- Debug option --
If the debuging mode is enable, a D is to be displayed.
For more information about he arc table mode, please read the documentation */
#ifdef DEBUG
  #define DEBUGSTRING "D"
#else
  #define DEBUGSTRING " "
#endif 

/* -- Version number -- */
#define _VERSION_ "Version SL2 V1.0"


/* -- Code header declaration -- */
#ifdef __HIWARE__
#pragma DATA_SEG VERSIONTITLE
#endif

const u8 version[3][0x10]={
  "DALIbyST7DALI " COMPILER ARC_TYPE,
  _VERSION_, 
  "(c)2003 by ST  " DEBUGSTRING
};

/* -- End of writing in memory section, swith back to default one --  */
#ifdef __CSMC__
  #pragma section ()
#endif 

#ifdef __HIWARE__
#pragma DATA_SEG DEFAULT
#endif

/* ----- End of code header section ----- */

/* file global variable */
volatile u8 Process_Status;
_tiny_ u16 HALTtimer;

//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

void main(void)
{ 
 /* Dummy access to avoid removal by compiler optimisation */
 #ifdef __CSMC__
  volatile u8 t; 
  t=version[t][t];
#endif
#ifdef __HIWARE__
  volatile u8 t; 
  t=version[t][t];
#endif   
  
   

/* Initialisation */                                                                
  CRS_Init();
  PORTS_Init();
  ITC_Init();   // Usefull for external IT //ALAL in the future to be used to exit from slow mode
  	
  Timer_Lite_Init(); 
  
  MCC_Init(); // Allow fCPU to be seen on pin MCO
  EEPROM_Init();
  DALIR_Init();
  EnableInterrupts;  
  
  
  AR_TIMER_Init();
  DALIC_Init();
  DALI_Init(); 
  

  PORTS_Switch_Red_LED(ON);
  PORTS_Switch_Green_LED(ON);
  
PORTS_Switch_Red_LED(OFF);//paolo
										  PORTS_Switch_Green_LED(OFF);//paolo
  Process_Status=0; 
  HALTtimer=1000;
  AR_TIMER_Set_PWM(0); //paolo
  PORTS_Switch_Red_LED(OFF);
										  PORTS_Switch_Green_LED(OFF);

  
	       
/* End of initialisation */

	while(1) 
	{            // never ending loop. (<=> jra assembler instruction)
	
		if(lite_timer_IT_state==1)
		{
		   Process_Lite_timer_IT(); //This function is called every 1 ms
								 //The main purpose is to manage fade effects
								 //(fade time and fade rate)
		
			switch (Process_Status) 
			{ //switch is used to act in case of bus failure (see documentation)
				case 00:
					      	  if (HALTtimer) 
									  {
										HALTtimer--;
										
									  }
									  else
									  {                                     
									   HALTtimer = 10000;  /* 60000*1ms=1mn*/
											PORTS_Switch_Red_LED(OFF);
										  PORTS_Switch_Green_LED(OFF);
                      ATCSR = 	0;
											//SLOWMODE_Enable();
											_asm ("WFI");
                      //_asm ("HALT");


											//SLOWMODE_Disable();
											
										}

					break;
				case 01:
					RTC_LaunchBusFailureTimer();
						PORTS_WAKE_UP_FOR_DALI_IT_DISABLE();
					Process_Status=2;
					break;
				case 02:
				   	if (0==PORTS_READ_DALI_IN_PIN())   
					{
						RTC_ProcessBusFailureTimer(); 
					}
				 	else
				 	{
				 		RTC_DoneBusFailureTimer();
				 		PORTS_WAKE_UP_FOR_DALI_IT_ENABLE();
						Process_Status=0; 
					}
					break;
                case 03:
					RTC_DoneBusFailureTimer();
					DALIC_Process_System_Failure();
				//		Process_Status=4;
				 	PORTS_WAKE_UP_FOR_DALI_IT_ENABLE();
					Process_Status=0;
                case 05:
					break;
				
		        default:
			       PORTS_Switch_Red_LED(OFF);
			       break;
			} //switch
		}  
		if(dali_receive_status == DALI_NEW_FRAME_RECEIVED) 
		{
			PORTS_Switch_Red_LED(OFF);
			PORTS_Switch_Green_LED(OFF);
			if (DALIC_isTalkingToMe()) 
			{
				DALIC_ProcessCommand();
				PORTS_Switch_Green_LED(ON);
			} 
			else
			{
			    PORTS_Switch_Red_LED(ON);
			}
            dali_receive_status = DALI_READY_TO_RECEIVE;
        }
	} // while(1) loop                            
} // main loop

/*** (c) 2003  STMcroelectronics ****************** END OF FILE ***/



