/**************** (c) 2002 STMicroelectronics **********************

PROJECT  : 
COMPILER : 

MODULE  :  map7FDALI.c
VERSION :  

CREATION DATE : 10.2001 

AUTHOR : CMG 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : ST72FDALI Hardware Register Mapping.

              This file contains the description of the hardware registers of
              the ST72FDALI Microcontroller.

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#include "lib.h"
#include "ports_hr.h"
#include "lite_timer_8bit_hr.h"
#include "pwm_ar_timer_12bit_hr.h"
#include "watchdog_timer_hr.h"
#include "flash_hr.h"
#include "eeprom_hr.h"
#include "spi_hr.h"
#include "adc_10bit_hr.h"
#include "interrupt_contr_hr.h"
#include "main_clock_contr_hr.h"
#include "clock_reset_supply_hr.h"
#include "dali_hr.h"
#include "auto_wake_up_hr.h"
#include "in_circuit_debug_hr.h"

/* ***************************************
   Peripherals Registers Definition
   *************************************** */                                                                     
                                                                  
/* I/O ports registers */ 
#pragma DATA_SEG SHORT PORT_A
volatile u8 PADR;					/* port A data register             */          
u8 PADDR;							/* port A data direction register   */
u8 PAOR;							/* port A option register           */  
                                                             
#pragma DATA_SEG SHORT PORT_B
volatile u8 PBDR;					/* port B data register             */          
u8 PBDDR;							/* port B data direction register   */
u8 PBOR;							/* port B option register           */  

#pragma DATA_SEG SHORT PORT_C
volatile u8 PCDR;					/* port C data register             */          
u8 PCDDR;							/* port C data direction register   */
                                                                                                                                                          
/* Lite Timer registers  */
#pragma DATA_SEG SHORT LITE_TIMER
volatile u8 LTCSR2;					/* Lite Timer Control Status Register 2 */
volatile u8 LTARR;					/* Lite Timer Auto Reload Register      */
volatile u8 LTCNTR;					/* Lite Timer Counter Register          */
volatile u8 LTCSR1;					/* Lite Timer Control Status Register 1 */
volatile u8 LTICR;					/* Lite Timer Input Capture Register    */
  
/* Auto Reload Timer 12bit */
#pragma DATA_SEG SHORT AR_TIMER
volatile u8 ATCSR;					/* Timer Control Status Register 	*/
volatile u8 CNTRH;					/* Counter Register High 			*/
volatile u8 CNTRL;					/* Counter Register Low 			*/
volatile u8 ATRH;					/* Auto-Reload Register High 		*/
volatile u8 ATRL;					/* Auto-Reload Register Low 		*/
volatile u8 PWMCR;					/* PWM Output Control Register 		*/
volatile u8 PWM0CSR;				/* PWM 0 Control Status Register 	*/
volatile u8 PWM1CSR;				/* PWM 1 Control Status Register 	*/
volatile u8 PWM2CSR;				/* PWM 2 Control Status Register 	*/
volatile u8 PWM3CSR;				/* PWM 3 Control Status Register 	*/
volatile u8 DCR0H;					/* PWM 0 Duty Cycle Register High	*/
volatile u8 DCR0L;					/* PWM 0 Duty Cycle Register Low 	*/
volatile u8 DCR1H;					/* PWM 1 Duty Cycle Register High	*/
volatile u8 DCR1L;					/* PWM 1 Duty Cycle Register Low 	*/
volatile u8 DCR2H;					/* PWM 2 Duty Cycle Register High	*/
volatile u8 DCR2L;					/* PWM 2 Duty Cycle Register Low 	*/
volatile u8 DCR3H;					/* PWM 3 Duty Cycle Register High	*/
volatile u8 DCR3L;					/* PWM 3 Duty Cycle Register Low 	*/
volatile u8 ATICRH;					/* Input Capture Register High		*/
volatile u8 ATICRL;					/* Input Capture Cycle Register Low	*/
volatile u8 TRANCR;					/* Transfer Control Register		*/
volatile u8 BREAKCR;				/* Break Register					*/

/* Watchdog Timer */
#pragma DATA_SEG SHORT WDG                                                                     
volatile u8 WDGCR;					/* Watchdog control register */                                                                               

/* Flash Register */                                                                        
#pragma DATA_SEG SHORT FLASH_CR                                                                     
volatile u8 FCSR;                 	/* FLASH Control Status Register 	*/         

/* EEPROM Register */                                                                        
#pragma DATA_SEG SHORT EEPROM_CR
volatile u8 EECSR;					/* EEPROM Control Register  */

/* Serial Peripheral Interface */                                            
#pragma DATA_SEG SHORT SPI
volatile u8 SPIDR;					/* SPI Data Register    */
u8 SPICR;							/* SPI Control Register */
volatile u8 SPISR;					/* SPI Status Register  */

/* Analog To Digital Converter */                                            
#pragma DATA_SEG SHORT ADC
volatile u8 ADCCSR;					/* ADC Control Status Register       */
volatile u8 ADCDRH;					/* ADC Data Register high           */
volatile u8 ADCDRL;					/* ADC Data Register low            */

/* Interrupt Controler Registers*/
#pragma DATA_SEG SHORT ITC_1
volatile u8 EICR;					/* External Interrupt Control Register */
#pragma DATA_SEG SHORT ITC_2
volatile u8 EISR;					/* External Interrupt Selection Register */
                            
/* Main Clock Control Register*/                                                      
#pragma DATA_SEG SHORT MCC
volatile u8 MCCSR;					/* Main Clock Control Status Register */

/* Clock, Reset and Supply Register */
#pragma DATA_SEG SHORT CRS
u8 RCCR;							/* RC Oscillator Control Register 			*/   
volatile u8 SICSR;					/* System Integrity Control Status Register */   

/* DALI Interface Registers */
#pragma DATA_SEG SHORT DALI
volatile u8 DCMCLK;					/* DALI CLock Register 				*/
volatile u8 DCMFA;					/* DALI Forward Address Register	*/
volatile u8 DCMFD;					/* DALI Forward Data Register		*/
volatile u8 DCMBD;					/* DALI Backward Data Register		*/
volatile u8 DCMCR;					/* DALI Control Register			*/
volatile u8 DCMCSR;					/* DALI Control/Status Register 	*/

/* Auto Wake Up Unit */
#pragma DATA_SEG SHORT AWU
volatile u8 AWUPR;					/* AWU Prescaler Register 			*/
volatile u8 AWUCSR;					/* AWU Control/Status Register		*/

/* In Circuit Debugging Unit */
#pragma DATA_SEG SHORT ICD
volatile u8 ICDCR;					/* ICD Control Register				*/
volatile u8 ICDSR;					/* ICD Status Register				*/
volatile u8 ICDBK1H;				/* ICD Breakpoint Register 1 High	*/
volatile u8 ICDBK1L;				/* ICD Breakpoint Register 1 Low	*/
volatile u8 ICDBK2H;				/* ICD Breakpoint Register 2 High	*/
volatile u8 ICDBK2L;				/* ICD Breakpoint Register 2 Low	*/

/*** (c) 2002 STMicroelectronics ****************** END OF FILE ***/
