/**************** (c) 2003  STMicroelectronics *********************
PROJECT  : DALI "gateway" Slave
COMPILER : Cosmic 

MODULE  :  ports.c
VERSION :  3

CREATION DATE : 10.2001 

AUTHOR : 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
******************************************************************************/

#include "lib.h"
#include "debug.h"

#include "ports_hr.h"
#include "ports.h"   
#include "globals.h"

#define LED_PORT	PADR
#define LED_DDR		PADDR
#define LED_OR		PAOR

#define PORTS_RED_LED 		0 	// 0 on ST7FDALI
#define PORTS_GREEN_LED		1	// 1 on STFDALI

#define WAKE_UP_FOR_DALI_IT_PORT PBDR
#define WAKE_UP_FOR_DALI_IT_DDR  PBDDR
#define WAKE_UP_FOR_DALI_IT_OR	PBOR
#define WAKE_UP_FOR_DALI_IT	5

#ifdef DEBUG
 #define PORTS_TEST_PIN_PORT PBDR
 #define PORTS_TEST_PIN_DDR  PBDDR
 #define PORTS_TEST_PIN_OR	 PBOR
 #define PORTS_TEST_PIN 	 3     
#endif

/* file global variable */
extern volatile u8 Process_Status;

/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the ports

COMMENTS     :
-----------------------------------------------------------------------------*/
void PORTS_Init(void)
{
    SetBit(LED_DDR,PORTS_RED_LED);
    SetBit(LED_DDR,PORTS_GREEN_LED);
    SetBit(LED_OR,PORTS_RED_LED);
    SetBit(LED_OR,PORTS_GREEN_LED);

    PORTS_Switch_Green_LED(OFF);
    PORTS_Switch_Red_LED(OFF);
    
     SetBit(WAKE_UP_FOR_DALI_IT_OR,WAKE_UP_FOR_DALI_IT);
//Configure the port as IT
//ALAL In fact PB5 as pull-up/push-pull, the interrupt config. is in the file interrupt_contr.c
    

    #ifdef DEBUG
      SetBit(PORTS_TEST_PIN_DDR,PORTS_TEST_PIN);
	  SetBit(PORTS_TEST_PIN_OR,PORTS_TEST_PIN); 
   	#endif
}

#ifdef DEBUG
 void PORTS_SetTestPIN(void){
   SetBit(PORTS_TEST_PIN_PORT,PORTS_TEST_PIN);
 }

 void PORTS_ClrTestPIN(void){
   ClrBit(PORTS_TEST_PIN_PORT,PORTS_TEST_PIN);
 }

 void PORTS_ToggleTestPIN(void){
  if (ValBit(PORTS_TEST_PIN_PORT,PORTS_TEST_PIN)){
    ClrBit(PORTS_TEST_PIN_PORT,PORTS_TEST_PIN);
  }else{
    SetBit(PORTS_TEST_PIN_PORT,PORTS_TEST_PIN);
  }
 } 
#endif


void PORTS_Switch_Red_LED(u8 sw){
  if (sw==ON) {
    ClrBit(LED_PORT,PORTS_RED_LED);
  } else {
    SetBit(LED_PORT,PORTS_RED_LED);
  }
}

void PORTS_Switch_Green_LED(u8 sw){
  if (sw==ON) {
    ClrBit(LED_PORT,PORTS_GREEN_LED);
  } else {
    SetBit(LED_PORT,PORTS_GREEN_LED);
  }
}


u8 PORTS_READ_DALI_IN_PIN(void)
{
    if (ValBit(WAKE_UP_FOR_DALI_IT_PORT,WAKE_UP_FOR_DALI_IT)!=0){
	return (1);}
	else {
	return (0);}
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_WAKE_UP_FOR_DALI_IT_ENABLE
INPUT/OUTPUT : None

DESCRIPTION  : Enable the external interrupt to wake up from Halt mode

COMMENTS     :
-----------------------------------------------------------------------------*/
void PORTS_WAKE_UP_FOR_DALI_IT_ENABLE(void)
{
    SetBit(WAKE_UP_FOR_DALI_IT_OR,WAKE_UP_FOR_DALI_IT); //Configure the port as IT
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_WAKE_UP_FOR_DALI_IT_DISABLE
INPUT/OUTPUT : None

DESCRIPTION  : Disable the external interrupt to wake up from Halt mode

COMMENTS     :
-----------------------------------------------------------------------------*/
void PORTS_WAKE_UP_FOR_DALI_IT_DISABLE(void)
{
    ClrBit(WAKE_UP_FOR_DALI_IT_OR,WAKE_UP_FOR_DALI_IT); //Configure the port as non IT
}


#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_2_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : used to wake up from Halt mode on receiving a DALI Frame

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void PORTS_2_Interrupt(void)
{ 
Process_Status=1;
}

/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/


