/**************** (c) 2001 STMicroelectronics **********************

PROJECT  : 
COMPILER : 

MODULE  :  pwm_ar_timer_12bit.c
VERSION :  

CREATION DATE : 10.2001

AUTHOR : PPG 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Functions 12-bit Autoreload Timer
              
 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#include "lib.h"
#include "debug.h"
#include "pwm_ar_timer_12bit_hr.h"
#include "pwm_ar_timer_12bit.h"

/*-----------------------------------------------------------------------------
ROUTINE NAME : AT_TIMER_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the 12-bit Autoreload Timer

COMMENTS     :
-----------------------------------------------------------------------------*/
void AR_TIMER_Init(void)
{
	ATCSR = 	b00010000b;			/* Timer Control Status Register 	*/
	ATRH = 		b00001111b;			/* Auto-Reload Register High 		*/
	ATRL = 		b00000000b;			/* Auto-Reload Register Low 		*/
	PWMCR = 	b00000001b;			/* PWM Output Control Register 		*/
	DCR0H = 	b00001111b;			/* PWM 0 Duty Cycle Register High	*/
	DCR0L =		b00000000b;			/* PWM 0 Duty Cycle Register Low 	*/
  TRANCR = 	b00000001b;			/* Transfer Control Register		*/
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : AR_TIMER_Set_PWM
INPUT/OUTPUT : None

DESCRIPTION  : Set new PWM-value for 12-bit Autoreload Timer

COMMENTS     : 
-----------------------------------------------------------------------------*/
void AR_TIMER_Set_PWM(u8 newval)
{

//	DCR0H = 	b00001111b;			/* PWM 0 Duty Cycle Register High	*/
	DCR0L =		newval;				/* PWM 0 Duty Cycle Register Low 	*/
	TRANCR = 	b00000001b;			/* Transfer Control Register		*/
}


/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/
 


