/**************** (c) 2002  STMicroelectronics **********************
PROJECT  : 
COMPILER : 

MODULE  :  pwm_ar_timer_12bit_hr.h
VERSION :  

CREATION DATE : 10.2001

AUTHOR :  PPG 8-bit Micro Application Team  

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#ifndef AR_TIMER_HR_H
#define AR_TIMER_HR_H


/*---REGISTERS---*/ 
#ifdef __CSMC__				 /* only for Cosmic Compiler	     */
@tiny extern volatile u8 ATCSR @0x00D;	 /* Timer Control Status Register    */
@tiny extern volatile u8 CNTRH @0x00E;	 /* Counter Register High 	     */
@tiny extern volatile u8 CNTRL @0x00F;	 /* Counter Register Low 	     */
@tiny extern volatile u8 ATRH @0x010;	 /* Auto-Reload Register High 	     */
@tiny extern volatile u8 ATRL @0x11;	 /* Auto-Reload Register Low 	     */
@tiny extern volatile u8 PWMCR @0x012;	 /* PWM Output Control Register      */
@tiny extern volatile u8 PWM0CSR @0x013; /* PWM 0 Control Status Register    */
@tiny extern volatile u8 PWM1CSR @0x014; /* PWM 1 Control Status Register    */
@tiny extern volatile u8 PWM2CSR @0x015; /* PWM 2 Control Status Register    */
@tiny extern volatile u8 PWM3CSR @0x016; /* PWM 3 Control Status Register    */
@tiny extern volatile u8 DCR0H @0x017;	 /* PWM Duty Cycle Register High     */
@tiny extern volatile u8 DCR0L @0x018;	 /* PWM Duty Cycle Register Low      */
@tiny extern volatile u8 DCR1H @0x019;	 /* PWM 1 Duty Cycle Register High   */
@tiny extern volatile u8 DCR1L @0x01A;	 /* PWM 1 Duty Cycle Register Low    */
@tiny extern volatile u8 DCR2H @0x01B;	 /* PWM 2 Duty Cycle Register High   */
@tiny extern volatile u8 DCR2L @0x01C;	 /* PWM 2 Duty Cycle Register Low    */
@tiny extern volatile u8 DCR3H @0x01D;	 /* PWM 3 Duty Cycle Register High   */
@tiny extern volatile u8 DCR3L @0x01E;	 /* PWM 3 Duty Cycle Register Low    */
@tiny extern volatile u8 ATICRH @0x01F;	 /* Input Capture Register High	     */
@tiny extern volatile u8 ATICRL @0x020;	 /* Input Capture Cycle Register Low */
@tiny extern volatile u8 TRANCR @0x021;	 /* Transfer Control Register	     */
@tiny extern volatile u8 BREAKCR @0x022; /* Break Register		     */
#endif

#ifdef __HIWARE__						/* only for HIWARE Compiler*/
#pragma DATA_SEG SHORT AR_TIMER
extern volatile u8 ATCSR;				/* Timer Control Status Register 	*/
extern volatile u8 CNTRH;				/* Counter Register High 			*/
extern volatile u8 CNTRL;				/* Counter Register Low 			*/
extern volatile u8 ATRH;				/* Auto-Reload Register High 		*/
extern volatile u8 ATRL;				/* Auto-Reload Register Low 		*/
extern volatile u8 PWMCR;				/* PWM Output Control Register 		*/
extern volatile u8 PWM0CSR;				/* PWM 0 Control Status Register 	*/
extern volatile u8 PWM1CSR;				/* PWM 1 Control Status Register 	*/
extern volatile u8 PWM2CSR;				/* PWM 2 Control Status Register 	*/
extern volatile u8 PWM3CSR;				/* PWM 3 Control Status Register 	*/
extern volatile u8 DCR0H;				/* PWM 0 Duty Cycle Register High	*/
extern volatile u8 DCR0L;				/* PWM 0 Duty Cycle Register Low 	*/
extern volatile u8 DCR1H;				/* PWM 1 Duty Cycle Register High	*/
extern volatile u8 DCR1L;				/* PWM 1 Duty Cycle Register Low 	*/
extern volatile u8 DCR2H;				/* PWM 2 Duty Cycle Register High	*/
extern volatile u8 DCR2L;				/* PWM 2 Duty Cycle Register Low 	*/
extern volatile u8 DCR3H;				/* PWM 3 Duty Cycle Register High	*/
extern volatile u8 DCR3L;				/* PWM 3 Duty Cycle Register Low 	*/
extern volatile u8 ATICRH;				/* Input Capture Register High		*/
extern volatile u8 ATICRL;				/* Input Capture Cycle Register Low	*/
extern volatile u8 TRANCR;				/* Transfer Control Register		*/
extern volatile u8 BREAKCR;				/* Break Register					*/
#pragma DATA_SEG DEFAULT
#endif


/*---CONSTANTS---*/

/* Auto Reload Timer 12bit Control Status Register bit definition  */

#define OVF         0x02        /* Overflow Flag                       */
#define OVFIE       0x01        /* Overflow Interrupt Enable           */
#define CMPIE       0x00        /* Compare Interrupt Enable            */

/* Auto Reload Timer 12bit PWM0 Control Status Register bit definition */

#define OP0         0x01        /* PWM0 Output Polarity    */
#define CMPF0       0x00        /* PWM0 Compare Flag       */
                                                                        
/* Auto Reload Timer 12bit PWM Output Control Register bit definition  */

#define OE0         0x00        /* PWM Output compare Enable */

/* Auto Reload Timer 12bit Transfer Control Register bit definition	*/

#define TRAN        0x00        /* Break actice	*/

/* Auto Reload Timer 12bit Break Control Register bit definition */

#define BA          0x05        /* Break actice		*/
#define BPEN        0x04        /* Break Pin Enable	*/

#endif

/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/

