/**************** (c) 2001 STMicroelectronics **********************

PROJECT  : 
COMPILER : 

MODULE  :  spi_hr.h
VERSION :  

CREATION DATE : 01.2001 

AUTHOR : PPG 8-bit Micro Application Team 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#ifndef SPI2_HR_H
#define SPI2_HR_H

/*---REGISTERS---*/ 
   
#ifdef __CSMC__							/* only for Cosmic Compiler*/
@tiny extern volatile u8 SPIDR @0x31;	/* SPI Data Register    */
@tiny extern u8 SPICR @0x32;			/* SPI Control Register */
@tiny extern volatile u8 SPISR @0x33;	/* SPI Status Register  */
#endif

#ifdef __HIWARE__						/* only for HIWARE Compiler*/
#pragma DATA_SEG SHORT SPI
extern volatile u8 SPIDR;				/* SPI Data Register    */
extern u8 SPICR;						/* SPI Control Register */
extern volatile u8 SPISR;				/* SPI Status Register  */
#pragma DATA_SEG DEFAULT
#endif



/*---CONSTANTS---*/

/* SPI Control Register bit definition */

#define SPIE        0x07        /* SPI interrupt enable          */
#define SPE         0x06        /* SPI Output enable             */
#define MSTR        0x04        /* SPI Master mode               */

/* SPI status register bit definition  */

#define SPIF        0x07        /* SPI data transfer flag        */
#define WCOL        0x06        /* SPI write collision status    */
#define MODF        0x04        /* SPI mode fault Flag           */

#endif


/*** (c) 2003  STMicroelectronics ****************** END OF FILE ***/

