;******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
;* File Name          : 71x_init_Address.s
;* Author             : MCD Application Team
;* Date First Issued  : 06/05/2005
;* Description        : This is the first code executed after RESET.
;*                      This code used to initialize system stacks
;*                      and critical peripherals before entering the C code.
;*                      This file is used with the EIC address method (AN1776)
;*******************************************************************************
;* History:
;*  06/05/2005 : Created
;*******************************************************************************
; THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
; CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
; AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
; OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
; OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
; CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
;******************************************************************************/

        PRESERVE8
        AREA    Init, CODE, READONLY


; --- Standard definitions of mode bits and interrupt (I & F) flags in PSRs

Mode_USR            EQU    0x10
Mode_FIQ            EQU    0x11
Mode_IRQ            EQU    0x12
Mode_SVC            EQU    0x13
Mode_ABT            EQU    0x17
Mode_UNDEF          EQU    0x1B
Mode_SYS            EQU    0x1F ; available on ARM Arch 4 and later

I_Bit               EQU    0x80 ; when I bit is set, IRQ is disabled
F_Bit               EQU    0x40 ; when F bit is set, FIQ is disabled


; --- System memory locations

RAM_Base            EQU    0x20000000
RAM_Limit           EQU    0x20010000
SRAM_Base           EQU    0x60000000
Stack_Base          EQU    RAM_Limit


USR_Stack_Length    EQU    4096
IRQ_Stack_Length    EQU    1024
SVC_Stack_Length    EQU    256
FIQ_Stack_Length    EQU    256
ABT_Stack_Length    EQU    256
UNDEF_Stack_Length  EQU    256


USR_Stack           EQU    Stack_Base                 ; USR stack
IRQ_Stack           EQU    USR_Stack-USR_Stack_Length ; followed by IRQ stack
SVC_Stack           EQU    IRQ_Stack-IRQ_Stack_Length ; followed by SVC stack
FIQ_Stack           EQU    SVC_Stack-SVC_Stack_Length ; followed by FIQ stack
ABT_Stack           EQU    FIQ_Stack-FIQ_Stack_Length ; followed by ABT stack
UNDEF_Stack         EQU    ABT_Stack-ABT_Stack_Length ; followed by UNDEF stack

EIC_Base_addr       EQU    0xFFFFF800; EIC base address
ICR_off_addr        EQU    0x00      ; Interrupt Control register offset
CIPR_off_addr       EQU    0x08      ; Current Interrupt Priority Register offset
IVR_off_addr        EQU    0x18      ; Interrupt Vector Register offset
FIR_off_addr        EQU    0x1C      ; Fast Interrupt Register offset
IER_off_addr        EQU    0x20      ; Interrupt Enable Register offset
IPR_off_addr        EQU    0x40      ; Interrupt Pending Bit Register offset
SIR0_off_addr       EQU    0x60      ; Source Interrupt Register 0

        ENTRY

; Export the Reset_Handler address
        EXPORT  Reset_Handler
; Improt function addresses from 71x_vect.s

        IMPORT  T0TIMIIRQHandler
        IMPORT  FLASHIRQHandler
        IMPORT  RCCUIRQHandler
        IMPORT  RTCIRQHandler
        IMPORT  WDGIRQHandler
        IMPORT  XTIIRQHandler
        IMPORT  USBHPIRQHandler
        IMPORT  I2C0ITERRIRQHandler
        IMPORT  I2C1ITERRIRQHandler
        IMPORT  UART0IRQHandler
        IMPORT  UART1IRQHandler
        IMPORT  UART2IRQHandler
        IMPORT  UART3IRQHandler
        IMPORT  BSPI0IRQHandler
        IMPORT  BSPI1IRQHandler
        IMPORT  I2C0IRQHandler
        IMPORT  I2C1IRQHandler
        IMPORT  CANIRQHandler
        IMPORT  ADC12IRQHandler
        IMPORT  T1TIMIIRQHandler
        IMPORT  T2TIMIIRQHandler
        IMPORT  T3TIMIIRQHandler
        IMPORT  HDLCIRQHandler
        IMPORT  USBLPIRQHandler
        IMPORT  T0TOIIRQHandler
        IMPORT  T0OC1IRQHandler
        IMPORT  T0OC2IRQHandler
Reset_Handler
         LDR     pc, =NextInst
NextInst
		NOP		; Wait for OSC stabilization
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP

        MSR     CPSR_c, #Mode_ABT:OR:F_Bit:OR:I_Bit
        LDR     SP, =ABT_Stack

        MSR     CPSR_c, #Mode_UNDEF:OR:F_Bit:OR:I_Bit
        LDR     SP,= UNDEF_Stack

        MSR     CPSR_c, #Mode_SVC:OR:F_Bit:OR:I_Bit
        LDR     SP, =RAM_Limit


; Initialize EIC with Address method
        LDR     r0, =EIC_Base_addr     ; r0 point EIC base address
        LDR     r1, =T0TIMIIRQHandler  ; Read T0TIMIIRQHandler address
        LDR     r2, =0xFFFF0000        ; Read mask
        AND     r4,r4,r2               ; mask the address
        STR     r1, [r0, #IVR_off_addr]; Write the MSB of the IRQ handler
                                       ; address
        ADD     r0,r0,#SIR0_off_addr   ; r0 point to EIC_SIR0 register

        MOV     r1, r1, LSL #16        ; Left the IRQ address
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =FLASHIRQHandler   ; Get FLASHIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =RCCUIRQHandler    ; Get RCCUIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =RTCIRQHandler     ; Get RTCIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =WDGIRQHandler     ; Get WDGIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =XTIIRQHandler     ; Get XTIIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =USBHPIRQHandler   ; Get USBHPIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =I2C0ITERRIRQHandler; Get I2C0ITERRIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =I2C1ITERRIRQHandler; Get I2C1ITERRIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =UART0IRQHandler   ; Get UART0IRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =UART1IRQHandler   ; Get UART1IRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =UART2IRQHandler   ; Get UART2IRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =UART3IRQHandler   ; Get UART3IRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =BSPI0IRQHandler   ; Get BSPI0IRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =BSPI1IRQHandler   ; Get BSPI1IRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =I2C0IRQHandler    ; Get I2C0IRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =I2C1IRQHandler    ; Get I2C1IRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =CANIRQHandler     ; Get CANIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =ADC12IRQHandler   ; Get ADC12IRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =T1TIMIIRQHandler  ; Get T1TIMIIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =T2TIMIIRQHandler  ; Get T2TIMIIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =T3TIMIIRQHandler  ; Get T3TIMIIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#16           ; Store the result in SIRx register

        LDR     r1, =HDLCIRQHandler    ; Get HDLCIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =USBLPIRQHandler   ; Get USBLPIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#12           ; Store the result in SIRx register

        LDR     r1, =T0TOIIRQHandler   ; Get T0TOIIRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =T0OC1IRQHandler   ; Get T0OC1IRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0],#4            ; Store the result in SIRx register

        LDR     r1, =T0OC2IRQHandler   ; Get T0OC2IRQHandler address
        MOV     r1, r1, LSL #16        ; Left shift the result
        STR     r1, [r0]               ; Store the result in SIRx register



; Continu stack initialization

       	MSR     CPSR_c, #Mode_FIQ:OR:I_Bit; Change to FIQ mode
        LDR     SP, =FIQ_Stack            ; Initialize FIQ stack pointer

       	MSR     CPSR_c, #Mode_IRQ:OR:I_Bit; Change to IRQ mode
        LDR     SP, =IRQ_Stack            ; Initialize IRQ stack pointer

        MSR     CPSR_c, #Mode_USR         ; Change to User mode, Enable IRQ and FIQ
        LDR     SP, =USR_Stack            ; Initialize USR stack pointer

        IMPORT  __main

; --- Now branches to a C lib function that copies RO data from their
;     load region to their execute region, create the RW and ZI regions
;     then jumps to user C main program.

        B       __main   ; Note : use B not BL, because an application will
                         ; never return this way

        LTORG
        
        END
;******************* (C) COPYRIGHT 2003 STMicroelectronics *****END OF FILE****
