/******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 06/05/2005
* Description        : Short Example program using the GPIO 0, GPIO 1,
*                      Timer 0 and Timer 1 for the STR71x microcontroller
*                      This file is developped for the (AN1776)
*                      GPIO 0 and GPIO 1 pins ports as Push-Pull output, and
*                      the Timer 0 and Timer 1 to generate overflow interrupt.
********************************************************************************
* History:
*  06/05/2005 : Created
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
#include "71x_lib.h"

int main(void)
{

#ifdef DEBUG
  debug();
#endif
/*  Channel priority configuration: channel 0 priority > channel 19 priority ----- */

  EIC->SIR[0] |= 0x000002;           /*  Configure the channel 0 priority */
  EIC->IER |= 1<<0;                  /*  Enable interrupts on channel 0 */

  EIC->SIR[19] |= 0x00000001;        /*  Configure the channel 19 priority */
  EIC->IER |= 1<<19;                 /*  Enable interrupt on channel 19 */

  EIC->ICR |= 0x00000001;            /*  Enable interrupts */

/*  Configure GPIO0 in Push-Pull output ------------------------------------------ */
  GPIO0->PC0 = 0xFFFF;
  GPIO0->PC1 = 0x0000;
  GPIO0->PC2 = 0xFFFF;
  GPIO0->PD  = 0x0000;               /*  reset pins */

/*  Configure GPIO1 in Push-Pull output ------------------------------------------ */
  GPIO1->PC0 = 0xFFFF;
  GPIO1->PC1 = 0x0000;
  GPIO1->PC2 = 0xFFFF;
  GPIO1->PD  = 0x0000;               /*  reset pins */

/*  TIM0 configuration ----------------------------------------------------------- */
  TIM0->CR2 &= ~0x2000;
  TIM0->CR2  = 0x200F;
  TIM0->CR1  = 0x8000;
  TIM0->CNTR = 0xFFF0;

/*  TIM1 configuration ------------------------------------------------------------*/
  TIM1->CR2 &= ~0x2000;
  TIM1->CR2  = 0x20FF;
  TIM1->CR1  = 0x8000;
  TIM1->CNTR = 0xFFFF;

  while(1);                          /*   infinite loop */
}
/******************* (C) COPYRIGHT 2003 STMicroelectronics *****END OF FILE****/
