/**************** (c) 2004  STMicroelectronics ********************************
     
PROJECT  : 3-phase AC induction motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  ACMParam.h
VERSION :  1.0.2

CREATION DATE :		March 2004

AUTHOR :	Microcontroller Division Applications

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Contains the Induction Motor control library parameters
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :
v1.0.1: Change PI_PROP_LOWSPD default value
v1.0.2: Add SLEW_LIMIT as parameter (previously in acmotor.c)

*******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
******************************************************************************/
#ifndef ACM_PRM
#define ACM_PRM

/////////////////////////// Miscellaneous settings  ///////////////////////////
#define SLEW_LIMIT	((u16)10)	/* Voltage and frequency increment/decrement 
											rate in ms (open loop mode) */

///////////////////////////////// V/f curve ///////////////////////////////////
// IMPORTANT CAUTION: if "VF_OFFSET + HIGHFREQ_LIMIT * VF_COEFF" value is
// greater than 0xFFFF, user should modify data type of variable Buffer inside
// ACM_VoltageMaxAllowed function; by default, it is set as U16

	#define  V_MAX ((u8)255)
	#define  V_MIN ((u8)30)
	#define VF_LOWFREQ_LIMIT ((u16)200)	// Resolution: 0.1Hz
	#define VF_HIGHFREQ_LIMIT ((u16)1000)	// Resolution: 0.1Hz
	// NOTA: multiplication by 256 is here to keep sufficient accuracy
	#define VF_COEFF ((u16) ( (u16)256 * ( V_MAX - V_MIN ) ) / ( VF_HIGHFREQ_LIMIT - VF_LOWFREQ_LIMIT ) )
	#define VF_OFFSET ((u16) VF_COEFF * VF_LOWFREQ_LIMIT )


///////////////////////////// General Start-Up conditions //////////////////////////////
	#define	VOLT_SLEWRATE ((u8)10)
	#define START_TIMEOUT	((u16)1800) 	/* Resolution: 1ms */
	#define EXTRA_TIMEOUT	((u16)1000 )


/* ------------------- ACM_GetOptimumSlip constants ------------------------ */

/* IMPORTANT CAUTION: if "SLIP_OFFSET + OPT_SLIP_HIGHFREQ_LIMIT * SLIP_COEFF"
value is greater than 0xFFFF, user should modify data type of variable Buffer
inside ACM_VoltageMaxAllowed function; by default, it is set as U16 */

#define  OPT_SLIP_LOWFREQ_LIMIT   ((u16)2000)
#define  OPT_SLIP_HIGHFREQ_LIMIT  ((u16)2500)

#define  OPT_SLIP_LOWFREQ         ((u8)30)
#define  OPT_SLIP_HIGHFREQ        ((u8)80)

#define  SLIP_COEFF  ((u16) ( (u16)256 * ( OPT_SLIP_HIGHFREQ - OPT_SLIP_LOWFREQ ) ) / ( OPT_SLIP_HIGHFREQ_LIMIT - OPT_SLIP_LOWFREQ_LIMIT ) )
#define  SLIP_OFFSET ((u16) SLIP_COEFF * OPT_SLIP_LOWFREQ_LIMIT )
/* NOTA: multiplication by 256 is here to keep sufficient accuracy */


/* ------------------- ACM_GetPIParam constants ------------------------ */
#define  PI_PROP_LOWSPD      	((u8)5)
#define  PI_PROP_HIGHSPD		((u8)0)

#define  PI_INT_LOWSPD      	((u8)50)
#define  PI_INT_HIGHSPD			((u8)60)

#define  PI_LOWFREQ_LIMIT       ((u16)500)
#define  PI_HIGHFREQ_LIMIT      ((u16)800)   

#define  PI_PROP_COEFF  ((u16) ( (u16)256 * ( PI_PROP_LOWSPD - PI_PROP_HIGHSPD ) ) / ( PI_HIGHFREQ_LIMIT - PI_LOWFREQ_LIMIT ) )
#define  PI_PROP_OFFSET ((u16) PI_PROP_COEFF * PI_LOWFREQ_LIMIT )    
/* NOTA: multiplication by 256 is here to keep sufficient accuracy */

#define  PI_INT_COEFF  ((u16) ( (u16)256 * ( PI_INT_HIGHSPD - PI_INT_LOWSPD ) ) / ( PI_HIGHFREQ_LIMIT - PI_LOWFREQ_LIMIT ) )
#define  PI_INT_OFFSET ((u16) PI_INT_COEFF * PI_LOWFREQ_LIMIT )
/* NOTA: multiplication by 256 is here to keep sufficient accuracy */

#define	SAMPLING_TIME	((u8)10)	/* PI regulator Sampling period */

#endif	/* ACM_PRM */

/*** (c) 2004 STMicroelectronics ****************** END OF FILE **************/ 

