/**************** (c) 2004  STMicroelectronics ********************************
     
PROJECT  : 3-phase AC induction motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  MTCParam.h
VERSION :  1.0.0

CREATION DATE :		March 2004

AUTHOR :	Microcontroller Division Applications

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Contains the Induction Motor control library parameters
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

*******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
******************************************************************************/
#ifndef MTC_PRM
#define MTC_PRM

#include "config.h"


/////////////////////// MTC Peripheral Input clock ////////////////////////////
	#define MTC_CLOCK	((u32)16000000) 	/* Resolution: 1Hz */

///////////////////////////// Motor Pole pairs ////////////////////////////////
	#define	POLE_PAIR_NUM 	((u8)1) /* Number of motor's poles pair */

//////////////////////////////// Speed Sensor /////////////////////////////////
	#define	TACHO_PULSE_PER_REV	((u8)8) /* Number of pulses per revolution given by tachogenerator */
	#define	ROTOR_SPEED_FACTOR	((u32) ( POLE_PAIR_NUM * ( MTC_CLOCK * 10 ) / TACHO_PULSE_PER_REV ) )
	#define	SPEED_OVERFLOW		((u16) ( ROTOR_SPEED_FACTOR / 0xFFFF ))
	#define SPEED_FIFO_SIZE 	((u8)4)

///////////////////////////// PWM Frequency ///////////////////////////////////
	#define CENTER_ALIGNED  	2   /* Definitions of PWM patterns type */
	#define EDGE_ALIGNED    	1

	#define PATTERN_TYPE	CENTER_ALIGNED

	#ifdef PWM_10BIT
		#define PWM_MCP0 ((u16)640)
		u8 OFFSET @0x0a;	// Trick to access OFFSET constant in assembly with immediate adressing mode
	#else
	#ifdef PWM_9BIT
		#define PWM_MCP0 ((u16)512)
		u8 OFFSET @0x08;	// Trick to access OFFSET constant in assembly with immediate adressing mode
	#endif
	#endif

	#define REP_RATE ((u8)3)	/* This defines the number of update interrupts per half PWM period */
	
	// Prescaler ratio defines PWM frequency in a rough way:
	// 0 -> 15.66kHz, 12.5 kHz (depending on CMP0 value)
	// 1 -> 7.8kHz
	// 3 -> 3.9kHz
	// 7 -> 1.95kHz
	#define PWM_PRSC ((u8)0)
	
	#if PATTERN_TYPE == CENTER_ALIGNED
		#define PWM_FREQ ((u16) (MTC_CLOCK * 2 / (u32)(PATTERN_TYPE * PWM_MCP0 *(PWM_PRSC+1)*(REP_RATE+1)))) /* Resolution: 1Hz */
	#else	/* EDGE_ALIGNED */
		#define PWM_FREQ ((u16) (MTC_CLOCK * 2 / (u32)(PATTERN_TYPE * (PWM_MCP0+1) *(PWM_PRSC+1)*(REP_RATE+1)))) /* Resolution: 1Hz */
	#endif

	#define STATOR_FREQ_RESOL ((u16) (((u32) PWM_FREQ * 10 ) / 256) )	/* To convert freq Cmd into appropriate unit */

///////////////////////// Sinewave frequency Range //////////////////////////////
	#define HIGHEST_FREQ	((u16)3400)	/* Sinewave Max Frequency (max theorical: 65535) */
	#define LOWEST_FREQ	((u16)30)		/* Sinewave Min Frequency */

////////////////////////////// Deadtime Value /////////////////////////////////
	#define DEADTIME	((u8)4)

////////////////////// Other Settings not modified by GUI /////////////////////
	#define PHASE_SHIFT	((s8)85)		/* (85/256) * 360 = 120 degrees */
	#define MAX_RATIO		((u8)7)		/* Max MTIM prescaler ratio defining the lowest expected speed feedback */

	#define L6386_POLARITY	((u8)0x3F)		/* Positive logic for L6386D drivers: PWM low state = Switch OFF */
	#define NEGATIVE_POLARITY	((u8)0x00)	/* Negative logic level: PWM low state = Switch ON */
	
	#define DRIVERS_POLARITY L6386_POLARITY
#endif	/* MTC_PRM */

/*** (c) 2004 STMicroelectronics ****************** END OF FILE **************/

