/**************** (c) 2004  STMicroelectronics ********************************
     
PROJECT  : 3-phase AC induction motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  Mainparam.h
VERSION :  1.0.1

CREATION DATE :		March 2004

AUTHOR :	Microcontroller Division Applications

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Contains the Induction Motor control library parameters
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

V1.0.1: Add Motor direction management

*******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
******************************************************************************/
#ifndef MAIN_PRM
#define MAIN_PRM

//////////////////////////// Start-Up Parameters //////////////////////////////

#define  DIRECTION      CW				// Open & Closed loop

#define  START_VOLTAGE 	((u8)30)		// Open Loop only

#define	START_FREQ 		((u16)150)	// Open & Closed Loop

#define	MIN_START_FREQ 	((u16)100)		// Closed Loop only, resolution: 0.1Hz


//////////////////////////////// Stop conditions //////////////////////////////
#define	BRAKE_DUTY_CYCLE	((u16)64)
#define	BRAKE_DURATION 		((u16)3000)


//////////////////// Closed Loop parameters ///////////////////////////////////
// This avoid the motor to exceed its max working slip during acceleration
#define	ACCEL_SLIP_LIMIT	((u16)100)
// This avoid the motor to become generator (reactive current source during decel.)
#define	DECEL_SLIP_LIMIT	((u16)10)


//*****************************************************************************
// Do not edit this part: conditional compilation keys definition
//*****************************************************************************
#define CW					0
#define CCW					255
#define TOGGLE				128

#endif	/* MAIN_PRM */
/*** (c) 2004 STMicroelectronics ****************** END OF FILE **************/