/**************** (c) 2004  STMicroelectronics **********************
     
PROJECT  : 3-phase AC induction motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  ST7_Misc.c
VERSION :  1.0.2

CREATION DATE : April 2004

AUTHOR :	Microcontroller Division Applications

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   ST7 specifics handling routines
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

September 04 (1.0.1): replace ST7FMC2N6.h by config.h for better flexibility.
April 05 (1.0.2): cleaner init of ISPR3

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
*******************************************************************************

******************************************************************************/

// Standard types definitions and ST7 specific macros
#include "lib.h"
// ST7 specifics related functions prototypes
#include "ST7_Misc.h"
// Library configuration and ST7FMC peripherals Hardware Registers declaration
#include "config.h"

/* -------------------------- Private constants ---------------------------- */
// ISPR0 Register interrupts priority definitions
#define MCES_LVL_0			((u8)0x02)
#define MCES_LVL_1			((u8)0x01)
#define MCES_LVL_2			((u8)0x00)
#define MCES_LVL_3			((u8)0x03)

#define MCC_SI_LVL_0			((u8)(0x02<<2))
#define MCC_SI_LVL_1			((u8)(0x01<<2))
#define MCC_SI_LVL_2			((u8)(0x00<<2))
#define MCC_SI_LVL_3			((u8)(0x03<<2))

#define EXT_IT0_LVL_0		((u8)(0x02<<4))
#define EXT_IT0_LVL_1		((u8)(0x01<<4))
#define EXT_IT0_LVL_2		((u8)(0x00<<4))
#define EXT_IT0_LVL_3		((u8)(0x03<<4))

#define EXT_IT1_LVL_0		((u8)(0x02<<6))
#define EXT_IT1_LVL_1		((u8)(0x01<<6))
#define EXT_IT1_LVL_2		((u8)(0x00<<6))
#define EXT_IT1_LVL_3		((u8)(0x03<<6))

// ----------------------- ISPR1 Register interrupts priority 
#define EXT_IT2_LVL_0			((u8)0x02)
#define EXT_IT2_LVL_1			((u8)0x01)
#define EXT_IT2_LVL_2			((u8)0x00)
#define EXT_IT2_LVL_3			((u8)0x03)

#define MTC_U_CL_SO_LVL_0		((u8)(0x02<<2))
#define MTC_U_CL_SO_LVL_1		((u8)(0x01<<2))
#define MTC_U_CL_SO_LVL_2		((u8)(0x00<<2))
#define MTC_U_CL_SO_LVL_3		((u8)(0x03<<2))

#define MTC_R_Z_LVL_0			((u8)(0x02<<4))
#define MTC_R_Z_LVL_1			((u8)(0x01<<4))
#define MTC_R_Z_LVL_2			((u8)(0x00<<4))
#define MTC_R_Z_LVL_3			((u8)(0x03<<4))

#define MTC_C_D_LVL_0			((u8)(0x02<<6))
#define MTC_C_D_LVL_1			((u8)(0x01<<6))
#define MTC_C_D_LVL_2			((u8)(0x00<<6))
#define MTC_C_D_LVL_3			((u8)(0x03<<6))

// ----------------------- ISPR2 Register interrupts priority 
#define SPI_LVL_0				((u8)0x02)
#define SPI_LVL_1				((u8)0x01)
#define SPI_LVL_2				((u8)0x00)
#define SPI_LVL_3				((u8)0x03)

#define TIMER_A_LVL_0		((u8)(0x02<<2))
#define TIMER_A_LVL_1		((u8)(0x01<<2))
#define TIMER_A_LVL_2		((u8)(0x00<<2))
#define TIMER_A_LVL_3		((u8)(0x03<<2))

#define TIMER_B_LVL_0		((u8)(0x02<<4))
#define TIMER_B_LVL_1		((u8)(0x01<<4))
#define TIMER_B_LVL_2		((u8)(0x00<<4))
#define TIMER_B_LVL_3		((u8)(0x03<<4))

#define SCI_LVL_0				((u8)(0x02<<6))
#define SCI_LVL_1				((u8)(0x01<<6))
#define SCI_LVL_2				((u8)(0x00<<6))
#define SCI_LVL_3				((u8)(0x03<<6))

// ----------------------- ISPR3 Register interrupts priority 
#define AVD_LVL_0				((u8)0x02)
#define AVD_LVL_1				((u8)0x01)
#define AVD_LVL_2				((u8)0x00)
#define AVD_LVL_3				((u8)0x03)

#define PWMART_LVL_0			((u8)(0x02<<2))
#define PWMART_LVL_1			((u8)(0x01<<2))
#define PWMART_LVL_2			((u8)(0x00<<2))
#define PWMART_LVL_3			((u8)(0x03<<2))


/*-----------------------------------------------------------------------------
ROUTINE Name : ST7_IntPrioritySetUp

Description: This function performs the initialisation of the Interrupt 
				Software Priority Registers for the nested interrupts management.
-----------------------------------------------------------------------------*/
void ST7_IntPrioritySetUp(void)
{
	// Interrupt Software priority Register 0
	// MCES: top level, others AVD medium/low priority (MCC, CSS, Ext int0, Ext int1)
	ISPR0 = MCES_LVL_3 + MCC_SI_LVL_1 + EXT_IT0_LVL_1 + EXT_IT1_LVL_1;

	// Interrupt Software priority Register 1
	// PMW update: top level, Ratio update and tacho capture medium/high level,
	// Ext int2 AVD medium/low priority
	ISPR1 = EXT_IT2_LVL_1 + MTC_U_CL_SO_LVL_3 + MTC_R_Z_LVL_2 + MTC_C_D_LVL_2;

	// Interrupt Software priority Register 2
	// SPI, TimerA, TimerB and SCI medium/low priority
	ISPR2 = SPI_LVL_1 + TIMER_A_LVL_1 + TIMER_B_LVL_1 + SCI_LVL_1;

	// Interrupt Software priority Register 3
	// PWMART medium/high priority, AVD medium/low priority
	ISPR3 = (AVD_LVL_1 + PWMART_LVL_2) | (u8)(0xF0);

}
/*** (c) 2004  STMicroelectronics **************************** END OF FILE ***/