/******************************************************************************
COPYRIGHT 2002 STMicroelectronics
Source File Name :  sci.h 
Group            : IPSW,CMG-IPDF
Author           : MCD Application Team
Date First Issued: 5/3/2002
********************************Documentation**********************************
General Purpose - Contains prototypes for all the functions of SCI

********************************Revision History*******************************
_______________________________________________________________________________
Date :5/3/2002 			Release:1.0
Date : March 2004			Release:2.0: customized for ST7MC
 		        		     
******************************************************************************/
#ifndef SCI_H
#define SCI_H  

// Library configuration and ST7FMC peripherals Hardware Registers declaration
// Also contains polling / interrupt driven communication choice
#include "config.h"

#include "lib.h"    /* Description of all the functions defined in this module. */


#define SCI_ErrValue 0x0f                         /*Error bits in SR register*/

typedef enum{										/*Parameters for Control Register1*/
	SCI_DEFAULT_PARAM1  	= (unsigned char) 0x00,     
	SCI_WORDLENGTH_9    	= (unsigned char) 0x10,
	SCI_ODPARITY_SELECT     = (unsigned char) 0x06,
	SCI_EVPARITY_SELECT 	= (unsigned char) 0x04,
	SCI_WAKEUP_ADDR     	= (unsigned char) 0x08
	}SCI_Type_Param1;

typedef enum {                             /*Parameters for Control Register2*/
	SCI_MUTE_ENABLE	        = (unsigned char) 0x02, 
	SCI_BREAK_ENABLE        = (unsigned char) 0x01,
	SCI_DEFAULT_PARAM2      = (unsigned char) 0x00
	}SCI_Type_Param2;

typedef enum {
	SCI_PR_1	= (unsigned char) 0x00,        /*parameters for baudrate register*/
	SCI_PR_3	= (unsigned char) 0x40,	
	SCI_PR_4	= (unsigned char) 0x80,
	SCI_PR_13	= (unsigned char) 0xc0,
	SCI_TR_1	= (unsigned char) 0x00,
	SCI_TR_2	= (unsigned char) 0x08,
	SCI_TR_4	= (unsigned char) 0x10,
	SCI_TR_8	= (unsigned char) 0x18,
	SCI_TR_16	= (unsigned char) 0x20,
	SCI_TR_32	= (unsigned char) 0x28,
	SCI_TR_64	= (unsigned char) 0x30,
	SCI_TR_128  = (unsigned char) 0x38,
	SCI_RR_1	= (unsigned char) 0x00,
	SCI_RR_2	= (unsigned char) 0x01,
	SCI_RR_4	= (unsigned char) 0x02,
	SCI_RR_8	= (unsigned char) 0x03,
	SCI_RR_16	= (unsigned char) 0x04,
	SCI_RR_32	= (unsigned char) 0x05,
	SCI_RR_64	= (unsigned char) 0x06,
	SCI_RR_128  = (unsigned char) 0x07
	}SCI_Baudrate_Type;

typedef enum {                           /*Parameters for enabling interrupts*/
        SCI_IDLE_LINE               = (unsigned char) 0x10,
        SCI_RECEIVE_OVERRUN	        = (unsigned char) 0x20,
        SCI_TRANSMIT_REGISTER_READY = (unsigned char) 0x80,
        SCI_FRAME_TRANSMITTED       = (unsigned char) 0x40,
        SCI_PARITY_ERROR            = (unsigned char) 0x01
	}SCI_IT_Type;

typedef enum {                                 /*Parameters for enabling mode*/
	SCI_TX_ENABLE		= (unsigned char) 0x08,
	SCI_RX_ENABLE		= (unsigned char) 0x04
	     }SCI_Mode_Type;

typedef enum {                                                  /*Error Types*/
	SCI_BUFFER_ONGOING		= (unsigned char) 0xff,
	SCI_STRING_ONGOING		= (unsigned char) 0xfe,
	SCI_NOISE_ERR		    = (unsigned char) 0x04,
	SCI_OVERRUN_ERR 		= (unsigned char) 0x08,
	SCI_FRAMING_ERR		    = (unsigned char) 0x02,
	SCI_PARITY_ERR          = (unsigned char) 0x01,
	SCI_RECEIVE_OK          = (unsigned char) 0x00,
	SCI_RX_DATA_EMPTY       = (unsigned char) 0xfd
	    }SCI_RxError_t;

void PrintUnsignedInt( unsigned int x );
void PrintUnsignedChar( unsigned char x );
void PrintSignedChar( signed char x );

void strcatu16(const unsigned char *PtrtoString, unsigned int x );

void SCI_Init ( SCI_Type_Param1,SCI_Type_Param2 );      /*Initialises the SCI*/

void SCI_Forced_Clear_Flag(void);                      /*Clears all the flags*/

void SCI_Compute_Baudrate(unsigned int BaudRate_Tx,unsigned int BaudRate_Rx);
                                              /*Computes the desired Baudrate*/

void SCI_Select_Baudrate ( SCI_Baudrate_Type); /*Selects the desired baudrate*/

#if (defined SCI_72F521 | defined SCI_72F62)
void SCI_Extend_Baudrate(SCI_Baudrate_Type,unsigned char,unsigned char); 
              /*Selects the desired baudrate with extended prescalar register*/
#endif

void SCI_IT_Enable (SCI_IT_Type );           /*Enables the desired interrupt*/

void SCI_IT_Disable ( SCI_IT_Type );    /*Disables the desired the interrupt*/
										 
void SCI_Mode(SCI_Mode_Type); 
                         /*Configures the SCI in transmitter or receiver mode*/

void SCI_PutByte(unsigned char);               /*Transmits a single data byte*/

BOOL SCI_IsTransmitCompleted( void);    /*Checks if transmission is completed*/

void SCI_PutBuffer(const unsigned char*,unsigned char); 
                                                    /*Transmits a user buffer*/

void SCI_PutString(const unsigned char*);                /*Transmits a string*/

BOOL SCI_9thBit_TxRx(BOOL);                   /*Transmits or receives 9th bit*/

unsigned char SCI_GetByte( void);               /*Receives a single data byte*/

#ifdef SCI_POLLING_RX
SCI_RxError_t SCI_GetBuffer(unsigned char*,unsigned char);	
    /*Receives continuous data into the user buffer and returns error status */
SCI_RxError_t SCI_GetString ( unsigned char*);	
  /*Receives a string in the user buffer and returns error status to the user*/
#endif

#ifdef SCI_ITDRV_WITHOUTBUF_RX
void SCI_GetBuffer (unsigned char*,unsigned char);		
            /*Starts the reception in user buffer in the interrupt subroutine*/
void SCI_GetString (unsigned char*); 				
   /*Starts reception of a string  in user buffer in the interrupt subroutine*/
#endif

SCI_RxError_t SCI_IsReceptionCompleted(void);	
              /*Checks if reception is completed and returns the error status*/

void SCI_IT_Function (void);
                         /*Carries out communication in Interrupt Driven mode*/
#endif

/**** (c) 2002   STMicroelectronics *************************** END OF FILE **/
