/**************** (c) 2004  STMicroelectronics **********************
     
PROJECT  : 3-phase AC induction motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  mtc.h
VERSION :  1.0.0

CREATION DATE : 

AUTHOR :	Microcontroller Division Applications

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Main Routine
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

#ifndef ACM_H
#define ACM_H  
/*****************************************************************************/

#include "config.h"

/* Public Constants -------------------------------------------------------- */
	#ifdef PI_PARAM_TUNING
		extern u8	Kp, Ki;
	#endif
/* Public Variables -------------------------------------------------------- */

/* Public type definition -------------------------------------------------- */
typedef enum
{
START_ONGOING,
START_OK,
START_FAIL
} StartStatus_t;


/* Public Functions prototypes --------------------------------------------- */
void ACM_Init(void);
u8	ACM_VoltageMaxAllowed(u16 StatorFrequency);
void ACM_InitSoftStart(u16 StatorFreq);
void ACM_InitSoftStart_OL(u16 StatorFreq);
StartStatus_t ACM_SoftStart(u16 MinRotorFreq);
BOOL ACM_SoftStartOL(u8 TargetVoltage);
void ACM_SustainSpeed(u16 Time);
void ACM_InitSlipFreqReg(u8 OptimumSlip);
u8 ACM_SlipRegulation(u8 OptimumSlip);
void ACM_GetPIParam(u16 StatorFrequency);
u8 ACM_GetOptimumSlip(u16 StatorFrequency);
/* Public  macros ---------------------------------------------------------- */

#endif
/** (c) 2004  STMicroelectronics ***************************** END OF FILE ***/