/**************** (c) 2004  STMicroelectronics **********************
     
PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  adc.h
VERSION :  1.1

CREATION DATE :    08.2003
AUTHOR :      Microcontroller Application Lab  / ST Hong Kong

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   ADC routine prototypes              

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

01.2004 (V. Onde) Rel 1.1: Add ADC_Init(), u8 GetHeatsinkTemp(), u8 GetBusVoltage()

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

#ifndef adc_H
#define adc_H  

/*****************************************************************************/

/* Public Constants -------------------------------------------------------- */

/* Public Variables -------------------------------------------------------- */

/* Public  macros ---------------------------------------------------------- */

/* Public Functions prototypes --------------------------------------------- */

void ADC_Init(void);

u8 ADC_GetRV1(void);           // returns AIN12 value
u8 ADC_GetRV2(void);           // returns AIN11 value
u8 ADC_GetRV3(void);           // returns AIN7 value

BOOL ADC_CheckOverTemp(void); 	// returns TRUE when heatsink over temperature
u8 ADC_GetHeatsinkTemp(void);	// returns Heatsink temperature value (arbitrary unit)

BOOL ADC_CheckOverVoltage(void); // returns TRUE when Bus voltage is too high
u8 ADC_GetBusVoltage(void);     // returns High Voltage Bus value (arbitrary unit)
	
#endif
/*** (c) 2004  STMicroelectronics ****************** END OF FILE ***/