/**************** (c) 2004  STMicroelectronics ********************************

PROJECT  : 3-phase AC induction motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  config.h
VERSION :  1.0.1

CREATION DATE : March 2004
AUTHOR :	Microcontroller Division Applications

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Conditional compilation keys for AC motor control library
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

September 04: add micro's HW register declaration (used by peripheral modules).

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
*******************************************************************************

******************************************************************************/

// Select here the ST7FMC salestype to have the corresponding HW registers description
// Source files are located by default in C:\Program Files\STMicroelectronics\st7toolset\include
#define __DEFINE_REGISTERS_STVD7_INCLUDE__
//#include "ST7FMC1K2.h"
//#include "ST7FMC2M9.h"
#include "ST7FMC2N6.h"
//#include "ST7FMC2R6.h"
//#include "ST7FMC2R7.h"
//#include "ST7FMC2S4.h"
//#include "ST7FMC2S5.h"


//-----------------------------------------------------------------------------
// Define here the desired control type
		// 0 -> Open loop
		// 1 -> Closed loop
#define CONTROL			1

//-----------------------------------------------------------------------------
// Define here the chosen PWM resolution (linked to PWM switching frequency)
		// 0 -> 9-bit: 1.95kHz, 3.9kHz, 7.8kHz, 15.66kHz: cf "MTCparam.h"
		// 1 -> 10-bit: 12.5 kHz
#define PWM_RESOLUTION	1

//-----------------------------------------------------------------------------
// Define here the way the closed loop parameters (Kp, Ki) are set
// if this label is commented, Kp and Ki are set according to a look-up table
// defined in ACMparam.h.

//#define PI_PARAM_TUNING

//-----------------------------------------------------------------------------
// Define here if you want to use the SCI interface to monitor some internal 
// variables during run time
// IMPORTANT NOTE: If communication is done by polling, this may 
// decrease the sampling rate of the PI Speed controller
//#define ENABLE_RS232

/*-------------- Select the mode of communication for the SCI ---------------*/

//#define SCI_POLLING_TX					/*Polling mode transmission*/
//#define SCI_POLLING_RX				/*polling mode reception*/
#define SCI_ITDRV_WITHOUTBUF_TX	/*Interrupt driven without buffer transmission mode*/
//#define SCI_ITDRV_WITHOUTBUF_RX	/*Interrupt driven without buffer reception mode*/


//*****************************************************************************
// Do not edit this part: conditional compilation keys definition
//*****************************************************************************
#if CONTROL == 0
	#define OPEN_LOOP
	#if defined (PI_PARAM_TUNING)
		#error "Invalid setup: No PI parameters in open loop"
	#endif

#else
	#define CLOSED_LOOP
#endif

#if PWM_RESOLUTION == 0
	#define PWM_9BIT
#else
	#define PWM_10BIT
#endif

/*** (c) 2004 STMicroelectronics ***************************** END OF FILE ***/