/**************** (c) 2004 STMicroelectronics **********************

PROJECT  :    Not applicable
COMPILER :    Not applicable

MODULE  :  lib.h
VERSION :  1.0.0

CREATION DATE : 01.2001

AUTHOR : Microcontroller Division Applications
			Consumer & Micro Group / STMicroelectronics

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : 

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 *****************************************************************************/

/* PUBLIC DECLARATIONS *******************************************************/

#ifndef LIB_H
#define LIB_H
            
/*--------------------------STANDARD TYPE DEFINITION-------------------------*/
typedef unsigned char u8;	/* unsigned 8 bit type definition */
typedef signed char s8;		/* signed 8 bit type definition */
typedef unsigned int u16;	/* unsigned 16 bit type definition */
typedef signed int s16;		/* signed 16 bit type definition */
typedef unsigned long u32;	/* unsigned 32 bit type definition */
typedef signed long s32;	/* signed 32 bit type definition */

#define U8_MAX		((u8)255)
#define S8_MAX		((s8)127)
#define S8_MIN		((s8)-128)
#define U16_MAX	((u16)65535)
#define S16_MAX	((s16)32767)
#define S16_MIN	((s16)-32768)
#define U32_MAX	((u32)4294967295)
#define S32_MAX	((s32)2147483647)
#define S32_MIN	((s32)-2147483648)
                                       
typedef union {				/* unsigned 16 bit type for 8 & 16 */
          u16 w_form;			/* bit accesses: 16> var.w_form    */
          struct {			/* 8> var.b_form.high/low          */
                  u8 high, low;
          } b_form;
  } TwoBytes;

typedef u8 BOOL;

/*--------------------------STANDARD CONSTANT DEFINITION---------------------*/
#define  FALSE               ((u8)0x00)
#define  TRUE                (!(FALSE))


/*--------------------------STANDARD MACRO DEFINITION------------------------*/
#define DIM_ARRAY(x) (sizeof(x) / sizeof(x[0])) /*Nbr of elements in array x[]*/
#define ABS(x) (x) > 0 ? (x) : -(x)			/* Absolute value of expression */

/*--------------------------------BIT ACCESSES-------------------------------*/
#define SetBit(VAR,Place)         ( VAR |= (1<<Place) )

#define ClrBit(VAR,Place)         ( VAR &= ((1<<Place)^255) )
#define AffBit(VAR,Place,Value)   ((Value) ? \
                                   (VAR |= (1<<Place)) : \
                                   (VAR &= ((1<<Place)^255)))
#define MskBit(Dest,Msk,Src)      ( Dest = (Msk & Src) | ((~Msk) & Dest) )

#define ValBit(VAR,Place)         (VAR & (1<<Place))

/*------------------------------- ST7 SPECIFICS -----------------------------*/
#ifdef __HIWARE__
 #define EnableInterrupts()	{ asm rim; }
 #define DisableInterrupts()	{ asm sim; }
 #define Nop()						{ asm nop; }
 #define Trap()					{ asm trap; }
 #define Wfi()						{ asm wfi; }
 #define PushCC()					{ asm push CC; }
 #define PopCC()					{ asm pop CC; }
#else
 #ifdef __CSMC__
  #define EnableInterrupts()	{_asm ("RIM");}
  #define DisableInterrupts()	{_asm ("SIM");}
  #define Nop()					{_asm ("NOP");}
  #define Trap()					{_asm ("TRAP");}
  #define Wfi()					{_asm ("WFI");}
  #define PushCC()				{_asm ("PUSH CC");}
  #define PopCC()					{_asm ("POP CC");}
 #else
  #error"Unsupported Compiler!"	/* Compiler Defines not found! */
 #endif
#endif

#endif
/*** (c) 2004 STMicroelectronics ****************** END OF FILE ***/
