/**************** (c) 2004  STMicroelectronics ********************************
     
PROJECT  : 3-phase AC induction motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  pwmart.h
VERSION :  1.0.0

CREATION DATE : April 2004

AUTHOR :	Microcontroller Division Applications

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   PWM Auto Reload timer low level routines
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

*******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
******************************************************************************/
#ifndef PWMART_H
#define PWMART_H

/* Public Constants -------------------------------------------------------- */
extern volatile u8 DebounceButton;
/* Public Variables -------------------------------------------------------- */

/* Public type definition -------------------------------------------------- */

/* Public Functions prototypes --------------------------------------------- */
void ART_Init(void);
void ART_Start(void);

void ART_SetTimeOutDuration(u16 Duration);
BOOL ART_IsTimeOutElapsed(void);

void ART_SetSequenceDuration(u16 Duration);
BOOL ART_IsSequenceCompleted(void);

void ART_SetSpeedRegPeriod(u8 Period);
BOOL ART_IsRegPeriodElapsed(void);

void ART_Set_TimeInMs(u16 Duration);
BOOL ART_Is_TimeInMsElapsed(void);

void ART_SetMainTimeBase(u8 Period);
BOOL ART_IsMainTimeElapsed(void);

void ART_SetWdgRfrshTime(u8 Period);
BOOL ART_IsWdgTimeElapsed(void);

#endif	/* PWMART_H */

/*** (c) 2004  STMicroelectronics **************************** END OF FILE ***/