/**************** (c) 2005  STMicroelectronics **********************
     
PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  LinSCI.c
LIBRARY VERSION  :  2.0

CREATION DATE :    08.2003
AUTHOR :      Florent COSTE	/  Microcontroller Application Lab  / ST Hong Kong

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Lin/SCI control routines

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

#include "lib.h"
#include "ST7MC_hr.h"
#include "LinSCI.h"
  
  
typedef enum 
{
BUSY, READY
} SCIStatus_t;


volatile u8 SCI_Tx_Timer;
static SCIStatus_t SCI_State;

u8 Tx_Index;	// SCI transmitter index ( 0 -> LIN_TX_BUFFER_SIZE-1)
u8 Lin_Tx_Buffer[LIN_TX_BUFFER_SIZE];



void SCI_Config(void)
{
SCIBRR = 0xc0;	// 38K bauds TX RX 

ClrBit(SCICR1,SCID);	// SCI on
SetBit(SCICR2,TE);	// Transmitter enable
}                                            

void  SCI_Send_Data(void)
{
switch(SCI_State)
	{
	case BUSY:
	default:
		if (ValBit(SCISR,TDRE))	SCI_State = READY;	// if previous transmission is over -> ready to transmit!
				
	case READY:
		SCI_State = BUSY;
		Tx_Index = 0;           // Reset Tx_Index
		SetBit(SCICR2,TCIE);	// Transmitter interrupt enable
		break;
	}
}


/*** (c) 2005  STMicroelectronics ****************** END OF FILE ***/
