/**************** (c) 2005  STMicroelectronics **********************
     
PROJECT  : ST7MC demokit
COMPILER : ST7 METROWERKS C (HIWARE) / COSMIC

MODULE  :  Misc.c
LIBRARY VERSION  :  2.0

CREATION DATE :    08.2003
AUTHOR :      Florent COSTE	/  Microcontroller Application Lab  / ST Hong Kong

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Miscellanous routines              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/
 
#include "version.h"
#include "lib.h"
#include "ST7MC_hr.h"
#include "mtc_hr.h"
#include "mtc.h"
#include "Misc.h" 
#include "Timer.h" 
#include "adc.h" 
#include "ports.h"   



/* -------------------------- Private constants ---------------------------- */
// ISPR0 Register interrupts priority definitions
#define MCES_LVL_0			((u8)0x02)
#define MCES_LVL_1			((u8)0x01)
#define MCES_LVL_2			((u8)0x00)
#define MCES_LVL_3			((u8)0x03)

#define MCC_SI_LVL_0			((u8)(0x02<<2))
#define MCC_SI_LVL_1			((u8)(0x01<<2))
#define MCC_SI_LVL_2			((u8)(0x00<<2))
#define MCC_SI_LVL_3			((u8)(0x03<<2))

#define EXT_IT0_LVL_0		((u8)(0x02<<4))
#define EXT_IT0_LVL_1		((u8)(0x01<<4))
#define EXT_IT0_LVL_2		((u8)(0x00<<4))
#define EXT_IT0_LVL_3		((u8)(0x03<<4))

#define EXT_IT1_LVL_0		((u8)(0x02<<6))
#define EXT_IT1_LVL_1		((u8)(0x01<<6))
#define EXT_IT1_LVL_2		((u8)(0x00<<6))
#define EXT_IT1_LVL_3		((u8)(0x03<<6))

// ----------------------- ISPR1 Register interrupts priority 
#define EXT_IT2_LVL_0			((u8)0x02)
#define EXT_IT2_LVL_1			((u8)0x01)
#define EXT_IT2_LVL_2			((u8)0x00)
#define EXT_IT2_LVL_3			((u8)0x03)

#define MTC_U_CL_SO_LVL_0		((u8)(0x02<<2))
#define MTC_U_CL_SO_LVL_1		((u8)(0x01<<2))
#define MTC_U_CL_SO_LVL_2		((u8)(0x00<<2))
#define MTC_U_CL_SO_LVL_3		((u8)(0x03<<2))

#define MTC_R_Z_LVL_0			((u8)(0x02<<4))
#define MTC_R_Z_LVL_1			((u8)(0x01<<4))
#define MTC_R_Z_LVL_2			((u8)(0x00<<4))
#define MTC_R_Z_LVL_3			((u8)(0x03<<4))

#define MTC_C_D_LVL_0			((u8)(0x02<<6))
#define MTC_C_D_LVL_1			((u8)(0x01<<6))
#define MTC_C_D_LVL_2			((u8)(0x00<<6))
#define MTC_C_D_LVL_3			((u8)(0x03<<6))

// ----------------------- ISPR2 Register interrupts priority 
#define SPI_LVL_0				((u8)0x02)
#define SPI_LVL_1				((u8)0x01)
#define SPI_LVL_2				((u8)0x00)
#define SPI_LVL_3				((u8)0x03)

#define TIMER_A_LVL_0		((u8)(0x02<<2))
#define TIMER_A_LVL_1		((u8)(0x01<<2))
#define TIMER_A_LVL_2		((u8)(0x00<<2))
#define TIMER_A_LVL_3		((u8)(0x03<<2))

#define TIMER_B_LVL_0		((u8)(0x02<<4))
#define TIMER_B_LVL_1		((u8)(0x01<<4))
#define TIMER_B_LVL_2		((u8)(0x00<<4))
#define TIMER_B_LVL_3		((u8)(0x03<<4))

#define SCI_LVL_0				((u8)(0x02<<6))
#define SCI_LVL_1				((u8)(0x01<<6))
#define SCI_LVL_2				((u8)(0x00<<6))
#define SCI_LVL_3				((u8)(0x03<<6))

// ----------------------- ISPR3 Register interrupts priority 
#define AVD_LVL_0				((u8)0x02)
#define AVD_LVL_1				((u8)0x01)
#define AVD_LVL_2				((u8)0x00)
#define AVD_LVL_3				((u8)0x03)

#define PWMART_LVL_0			((u8)(0x02<<2))
#define PWMART_LVL_1			((u8)(0x01<<2))
#define PWMART_LVL_2			((u8)(0x00<<2))
#define PWMART_LVL_3			((u8)(0x03<<2))



/*-----------------------------------------------------------------------------
ROUTINE Name :  ST7_IntPrioritySetUp

Description:	Interrupt priorities magament routines.
Input/Output:	none/none
Comments: 	None
-----------------------------------------------------------------------------*/
void ST7_IntPrioritySetUp(void)
{
	// Interrupt Software priority Register 0
	// MCES: top level, others lowest level (MCC, CSS, Ext int0, Ext int1)
	ITSPR0 = MCES_LVL_3 + MCC_SI_LVL_2 + EXT_IT0_LVL_2 + EXT_IT1_LVL_2;
  
	// Interrupt Software priority Register 1
	// Commutation/Demag. highest priority, PMW update low priority, Ratio update low priority,
	// Ext int2 not used
	ITSPR1 = EXT_IT2_LVL_2 + MTC_U_CL_SO_LVL_2 + MTC_R_Z_LVL_2 + MTC_C_D_LVL_3;

	// Interrupt Software priority Register 2
	// TimerB low priority, SPI, TimerA and SCI not used
	ITSPR2 = SPI_LVL_2 + TIMER_A_LVL_2 + TIMER_B_LVL_2 + SCI_LVL_2;

	// Interrupt Software priority Register 3
	// PWMART and AVD not used
	ITSPR3 = (AVD_LVL_2 + PWMART_LVL_2) | (u8)(0xf0);   // bit 5,6,7,8 not used (keep at '1')
}


/*-----------------------------------------------------------------------------
ROUTINE Name :  Waitxxx

Description:	Waiting routines.
Input/Output:	none/none
Comments: 	None
-----------------------------------------------------------------------------*/

void Wait(u8 time)
{
timer_10ms = time;
while (timer_10ms != 0);
}

void Wait100us(void)
{
u8 i;

for (i=0; i<18; i++)    Wait1us();
}

void Wait1ms(void)
{
u8 i;

for (i=0; i<180; i++)    Wait1us();;
}


/*-----------------------------------------------------------------------------
ROUTINE Name :  Chk_Power_Motor_Status

Description:	Check temperature level, high voltage bus and update status flag
                accordingly. 
Input/Output:	none/BOOL
Comments: 	None
-----------------------------------------------------------------------------*/

void Chk_Power_Motor_Status(void)
{
if (Get_Temperature() == TRUE)    
    {
    SetBit(Power_Motor_Status,OverHeat);
    SetMotorStatus(HARD_FAILURE);
    }
else ClrBit(Power_Motor_Status,OverHeat);
if (Get_HVBus() == TRUE)          
    {
    SetBit(Power_Motor_Status,OverVoltage);
    SetMotorStatus(HARD_FAILURE);
    }
else ClrBit(Power_Motor_Status,OverVoltage);

if (timer_CL_10ms ==0) ClrBit(Power_Motor_Status,OverCurrent);
else if (timer_CL_10ms <= 10) MIMR |= CLIM_MSK;    // re-validate CL Int. after 200 ms

if ((Power_Motor_Status & Hard_Failure_MSK) != 0x00)    // check if one of the previous                                    
    {                                       // status flags has been set
    Flash_Red_Led();
    timer_10ms = 50;  // 0.5 sec delay
    }
} 




/*** (c) 2005  STMicroelectronics ****************** END OF FILE ***/
